/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.spawning.random;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.spawning.random.SpawnPointType;
import io.lumine.xikage.mythicmobs.utils.version.MinecraftVersions;
import io.lumine.xikage.mythicmobs.utils.version.ServerVersion;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class RandomSpawnPoint {
    protected AbstractEntity entity;
    protected AbstractLocation location;
    protected CreatureSpawnEvent.SpawnReason spawnReason;
    protected SpawnPointType pointType;
    protected float levelMod = 1.0f;

    public RandomSpawnPoint(AbstractLocation location) {
        this.entity = null;
        this.location = location;
        this.spawnReason = CreatureSpawnEvent.SpawnReason.CUSTOM;
        Location l = BukkitAdapter.adapt(location);
        SpawnPointType pt = ServerVersion.isBeforeOrEq(MinecraftVersions.v1_15) ? (!l.getBlock().getType().isOccluding() ? (l.getBlock().isLiquid() ? (l.getBlock().getType().equals((Object)Material.LAVA) ? SpawnPointType.LAVA : SpawnPointType.SEA) : (l.subtract(0.0, 1.0, 0.0).getBlock().getType().isOccluding() ? SpawnPointType.LAND : SpawnPointType.AIR)) : SpawnPointType.GROUND) : SpawnPointType.GROUND;
        this.pointType = pt;
    }

    public RandomSpawnPoint(AbstractLocation location, SpawnPointType pointType) {
        this.entity = null;
        this.location = location;
        this.spawnReason = CreatureSpawnEvent.SpawnReason.NATURAL;
        this.pointType = pointType;
    }

    public RandomSpawnPoint(AbstractEntity entity, AbstractLocation location, CreatureSpawnEvent.SpawnReason spawnReason) {
        this(entity, location, spawnReason, null);
        Location loc = BukkitAdapter.adapt(location);
        SpawnPointType pt = ServerVersion.isBeforeOrEq(MinecraftVersions.v1_15) ? (!loc.getBlock().getType().isOccluding() ? (loc.getBlock().isLiquid() ? (loc.getBlock().getType().equals((Object)Material.LAVA) ? SpawnPointType.LAVA : SpawnPointType.SEA) : (loc.subtract(0.0, 1.0, 0.0).getBlock().getType().isOccluding() ? SpawnPointType.LAND : SpawnPointType.AIR)) : SpawnPointType.GROUND) : SpawnPointType.GROUND;
        this.pointType = pt;
    }

    public RandomSpawnPoint(AbstractEntity entity, AbstractLocation location, CreatureSpawnEvent.SpawnReason spawnReason, SpawnPointType pt) {
        this.entity = entity;
        this.location = location;
        this.spawnReason = spawnReason;
        this.pointType = pt;
    }

    public AbstractEntity getEntity() {
        return this.entity;
    }

    public AbstractLocation getLocation() {
        return this.location;
    }

    public CreatureSpawnEvent.SpawnReason getReason() {
        return this.spawnReason;
    }

    public Biome getBiome() {
        return BukkitAdapter.adapt(this.location).getWorld().getBiome(this.location.getBlockX(), this.location.getBlockZ());
    }

    public SpawnPointType getPointType() {
        return this.pointType;
    }

    public float getLevelMod() {
        return this.levelMod;
    }

    public void setLevelMod(float l) {
        this.levelMod = l;
    }
}

