/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils;

import io.lumine.xikage.mythicmobs.utils.network.messaging.redis.Redis;
import io.lumine.xikage.mythicmobs.utils.promise.Promise;
import io.lumine.xikage.mythicmobs.utils.redis.jedis.Jedis;
import io.lumine.xikage.mythicmobs.utils.redis.jedis.JedisPool;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;

public final class NetworkCache {
    public static Redis get() {
        Redis messenger = (Redis)Bukkit.getServer().getServicesManager().load(Redis.class);
        return messenger;
    }

    public static JedisPool getPool() {
        return NetworkCache.get().getPool();
    }

    public static Promise<String> getValue(@Nonnull String key) {
        return Promise.supplyingAsync(() -> {
            try (Jedis j = NetworkCache.getPool().getResource();){
                String string = j.get(key);
                return string;
            }
        });
    }

    public static String getValueSync(@Nonnull String key) {
        try (Jedis j = NetworkCache.getPool().getResource();){
            String string = j.get(key);
            return string;
        }
    }

    public static Promise<Boolean> setMapValue(@Nonnull String key, Map<String, String> value) {
        return Promise.supplyingAsync(() -> {
            try (Jedis j = NetworkCache.getPool().getResource();){
                j.hset(key, value);
                Boolean bl = true;
                return bl;
            }
        });
    }

    public static void setMapValueSync(@Nonnull String key, Map<String, String> value) {
        try (Jedis j = NetworkCache.getPool().getResource();){
            j.hset(key, value);
        }
    }

    public static Promise<Boolean> deleteMapValue(@Nonnull String key, @Nonnull String field) {
        return Promise.supplyingAsync(() -> {
            try (Jedis j = NetworkCache.getPool().getResource();){
                j.hdel(key, field);
                Boolean bl = true;
                return bl;
            }
        });
    }

    public static void deleteMapValueSync(@Nonnull String key, @Nonnull String field) {
        try (Jedis j = NetworkCache.getPool().getResource();){
            j.hdel(key, field);
        }
    }

    public static Promise<Map<String, String>> getMap(@Nonnull String key) {
        return Promise.supplyingAsync(() -> {
            try (Jedis j = NetworkCache.getPool().getResource();){
                Map<String, String> map = j.hgetAll(key);
                return map;
            }
        });
    }

    public static Map<String, String> getMapSync(@Nonnull String key) {
        try (Jedis j = NetworkCache.getPool().getResource();){
            Map<String, String> map = j.hgetAll(key);
            return map;
        }
    }

    public static Promise<String> getMapValue(@Nonnull String key, @Nonnull String field) {
        return Promise.supplyingAsync(() -> {
            try (Jedis j = NetworkCache.getPool().getResource();){
                String string = j.hget(key, field);
                return string;
            }
        });
    }

    public static String getMapValueSync(@Nonnull String key, @Nonnull String field) {
        try (Jedis j = NetworkCache.getPool().getResource();){
            String string = j.hget(key, field);
            return string;
        }
    }

    public static Promise<Boolean> addListValue(@Nonnull String key, @Nonnull String value) {
        return Promise.supplyingAsync(() -> {
            try (Jedis j = NetworkCache.getPool().getResource();){
                j.lpush(key, value);
            }
            return true;
        });
    }

    public static void addListValueSync(@Nonnull String key, @Nonnull String value) {
        try (Jedis j = NetworkCache.getPool().getResource();){
            j.lpush(key, value);
        }
    }

    public static Promise<Boolean> removeListValue(@Nonnull String key, @Nonnull String value) {
        return Promise.supplyingAsync(() -> {
            try (Jedis j = NetworkCache.getPool().getResource();){
                j.lrem(key, 0L, value);
                Boolean bl = true;
                return bl;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
        });
    }

    public static void removeListValueSync(@Nonnull String key, @Nonnull String value) {
        try (Jedis j = NetworkCache.getPool().getResource();){
            j.lrem(key, 0L, value);
        }
    }

    public static Promise<List<String>> getListValues(@Nonnull String key) {
        return Promise.supplyingAsync(() -> {
            try (Jedis j = NetworkCache.getPool().getResource();){
                List<String> list = j.lrange(key, 0L, -1L);
                return list;
            }
        });
    }

    public static List<String> getListValuesSync(@Nonnull String key) {
        try (Jedis j = NetworkCache.getPool().getResource();){
            List<String> list = j.lrange(key, 0L, -1L);
            return list;
        }
    }

    public static Promise<Boolean> setValue(@Nonnull String key, @Nonnull String value) {
        return Promise.supplyingAsync(() -> {
            try (Jedis j = NetworkCache.getPool().getResource();){
                j.set(key, value);
            }
            return true;
        });
    }

    public static void setValueSync(@Nonnull String key, @Nonnull String value) {
        try (Jedis j = NetworkCache.getPool().getResource();){
            j.set(key, value);
        }
    }

    public static Promise<Boolean> deleteKey(@Nonnull String key) {
        return Promise.supplyingAsync(() -> {
            try (Jedis j = NetworkCache.getPool().getResource();){
                j.del(key);
                Boolean bl = true;
                return bl;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
        });
    }

    public static void deleteKeySync(@Nonnull String key) {
        try (Jedis j = NetworkCache.getPool().getResource();){
            j.del(key);
        }
    }

    private NetworkCache() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }
}

