/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils;

import io.lumine.xikage.mythicmobs.utils.annotation.NonnullByDefault;
import io.lumine.xikage.mythicmobs.utils.logging.Log;
import io.lumine.xikage.mythicmobs.utils.plugin.LoaderUtils;
import io.lumine.xikage.mythicmobs.utils.promise.ThreadContext;
import io.lumine.xikage.mythicmobs.utils.tasks.LumineExecutors;
import io.lumine.xikage.mythicmobs.utils.tasks.Task;
import io.lumine.xikage.mythicmobs.utils.tasks.TaskScheduler;
import io.lumine.xikage.mythicmobs.utils.tasks.Ticks;
import io.lumine.xikage.mythicmobs.utils.tasks.builder.TaskBuilder;
import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitScheduler;

@NonnullByDefault
public final class Schedulers {
    private static final TaskScheduler SYNC_SCHEDULER = new SyncScheduler();
    private static final TaskScheduler ASYNC_SCHEDULER = new AsyncScheduler();

    public static TaskScheduler get(ThreadContext context) {
        switch (context) {
            case SYNC: {
                return Schedulers.sync();
            }
            case ASYNC: {
                return Schedulers.async();
            }
        }
        throw new AssertionError();
    }

    public static TaskScheduler sync() {
        return SYNC_SCHEDULER;
    }

    public static TaskScheduler async() {
        return ASYNC_SCHEDULER;
    }

    public static BukkitScheduler bukkit() {
        return Bukkit.getScheduler();
    }

    public static TaskBuilder builder() {
        return TaskBuilder.newBuilder();
    }

    private Schedulers() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }

    private static class LumineAsyncTask
    implements Runnable,
    Task {
        private final Consumer<Task> backingTask;
        private final ScheduledFuture<?> future;
        private final AtomicInteger counter = new AtomicInteger(0);
        private final AtomicBoolean cancelled = new AtomicBoolean(false);

        private LumineAsyncTask(Consumer<Task> backingTask, long delay, TimeUnit delayUnit, long interval, TimeUnit intervalUnit) {
            this.backingTask = backingTask;
            this.future = LumineExecutors.asyncLumine().scheduleAtFixedRate(this, delayUnit.toNanos(delay), intervalUnit.toNanos(interval), TimeUnit.NANOSECONDS);
        }

        @Override
        public void run() {
            if (this.cancelled.get()) {
                return;
            }
            try {
                this.backingTask.accept(this);
                this.counter.incrementAndGet();
            }
            catch (Throwable e) {
                Log.severe("[SCHEDULER] Exception thrown whilst executing task");
                e.printStackTrace();
            }
        }

        @Override
        public int getTimesRan() {
            return this.counter.get();
        }

        @Override
        public boolean stop() {
            if (!this.cancelled.getAndSet(true)) {
                this.future.cancel(false);
                return true;
            }
            return false;
        }

        @Override
        public int getBukkitId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasTerminated() {
            return this.cancelled.get();
        }
    }

    private static class LumineTask
    extends BukkitRunnable
    implements Task {
        private final Consumer<Task> backingTask;
        private final AtomicInteger counter = new AtomicInteger(0);
        private final AtomicBoolean cancelled = new AtomicBoolean(false);

        private LumineTask(Consumer<Task> backingTask) {
            this.backingTask = backingTask;
        }

        public void run() {
            if (this.cancelled.get()) {
                this.cancel();
                return;
            }
            try {
                this.backingTask.accept(this);
                this.counter.incrementAndGet();
            }
            catch (Throwable e) {
                Log.severe("[SCHEDULER] Exception thrown whilst executing task");
                e.printStackTrace();
            }
            if (this.cancelled.get()) {
                this.cancel();
            }
        }

        @Override
        public int getTimesRan() {
            return this.counter.get();
        }

        @Override
        public boolean stop() {
            return !this.cancelled.getAndSet(true);
        }

        @Override
        public int getBukkitId() {
            return this.getTaskId();
        }

        @Override
        public boolean hasTerminated() {
            return this.cancelled.get();
        }
    }

    private static final class AsyncScheduler
    implements TaskScheduler {
        private AsyncScheduler() {
        }

        @Override
        public void execute(Runnable runnable) {
            LumineExecutors.asyncLumine().execute(runnable);
        }

        @Override
        @Nonnull
        public ThreadContext getContext() {
            return ThreadContext.ASYNC;
        }

        @Override
        @Nonnull
        public Task runRepeating(@Nonnull Consumer<Task> consumer, long delayTicks, long intervalTicks) {
            Objects.requireNonNull(consumer, "consumer");
            LumineTask task = new LumineTask(consumer);
            task.runTaskTimerAsynchronously((Plugin)LoaderUtils.getPlugin(), delayTicks, intervalTicks);
            return task;
        }

        @Override
        @Nonnull
        public Task runRepeating(@Nonnull Consumer<Task> consumer, long delay, @Nonnull TimeUnit delayUnit, long interval, @Nonnull TimeUnit intervalUnit) {
            Objects.requireNonNull(consumer, "consumer");
            return new LumineAsyncTask(consumer, delay, delayUnit, interval, intervalUnit);
        }
    }

    private static final class SyncScheduler
    implements TaskScheduler {
        private SyncScheduler() {
        }

        @Override
        public void execute(Runnable runnable) {
            LumineExecutors.sync().execute(runnable);
        }

        @Override
        @Nonnull
        public ThreadContext getContext() {
            return ThreadContext.SYNC;
        }

        @Override
        @Nonnull
        public Task runRepeating(@Nonnull Consumer<Task> consumer, long delayTicks, long intervalTicks) {
            Objects.requireNonNull(consumer, "consumer");
            LumineTask task = new LumineTask(consumer);
            task.runTaskTimer((Plugin)LoaderUtils.getPlugin(), delayTicks, intervalTicks);
            return task;
        }

        @Override
        @Nonnull
        public Task runRepeating(@Nonnull Consumer<Task> consumer, long delay, @Nonnull TimeUnit delayUnit, long interval, @Nonnull TimeUnit intervalUnit) {
            return this.runRepeating(consumer, Ticks.from(delay, delayUnit), Ticks.from(interval, intervalUnit));
        }
    }
}

