/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.adventure.audience;

import io.lumine.xikage.mythicmobs.utils.adventure.audience.Audiences;
import io.lumine.xikage.mythicmobs.utils.adventure.audience.EmptyAudience;
import io.lumine.xikage.mythicmobs.utils.adventure.audience.ForwardingAudience;
import io.lumine.xikage.mythicmobs.utils.adventure.audience.MessageType;
import io.lumine.xikage.mythicmobs.utils.adventure.bossbar.BossBar;
import io.lumine.xikage.mythicmobs.utils.adventure.identity.Identified;
import io.lumine.xikage.mythicmobs.utils.adventure.identity.Identity;
import io.lumine.xikage.mythicmobs.utils.adventure.inventory.Book;
import io.lumine.xikage.mythicmobs.utils.adventure.sound.Sound;
import io.lumine.xikage.mythicmobs.utils.adventure.sound.SoundStop;
import io.lumine.xikage.mythicmobs.utils.adventure.text.Component;
import io.lumine.xikage.mythicmobs.utils.adventure.text.ComponentLike;
import io.lumine.xikage.mythicmobs.utils.adventure.title.Title;
import java.util.Arrays;
import java.util.stream.Collector;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface Audience {
    public static @NonNull Audience empty() {
        return EmptyAudience.INSTANCE;
    }

    public static @NonNull Audience audience(Audience ... audiences) {
        int length = audiences.length;
        if (length == 0) {
            return Audience.empty();
        }
        if (length == 1) {
            return audiences[0];
        }
        return Audience.audience(Arrays.asList(audiences));
    }

    public static @NonNull ForwardingAudience audience(@NonNull Iterable<? extends Audience> audiences) {
        return () -> audiences;
    }

    public static @NonNull Collector<? super Audience, ?, ForwardingAudience> toAudience() {
        return Audiences.COLLECTOR;
    }

    default public void sendMessage(@NonNull ComponentLike message) {
        this.sendMessage(Identity.nil(), message);
    }

    default public void sendMessage(@NonNull Identified source, @NonNull ComponentLike message) {
        this.sendMessage(source, message.asComponent());
    }

    default public void sendMessage(@NonNull Identity source, @NonNull ComponentLike message) {
        this.sendMessage(source, message.asComponent());
    }

    default public void sendMessage(@NonNull Component message) {
        this.sendMessage(Identity.nil(), message);
    }

    default public void sendMessage(@NonNull Identified source, @NonNull Component message) {
        this.sendMessage(source, message, MessageType.SYSTEM);
    }

    default public void sendMessage(@NonNull Identity source, @NonNull Component message) {
        this.sendMessage(source, message, MessageType.SYSTEM);
    }

    default public void sendMessage(@NonNull ComponentLike message, @NonNull MessageType type) {
        this.sendMessage(Identity.nil(), message, type);
    }

    default public void sendMessage(@NonNull Identified source, @NonNull ComponentLike message, @NonNull MessageType type) {
        this.sendMessage(source, message.asComponent(), type);
    }

    default public void sendMessage(@NonNull Identity source, @NonNull ComponentLike message, @NonNull MessageType type) {
        this.sendMessage(source, message.asComponent(), type);
    }

    default public void sendMessage(@NonNull Component message, @NonNull MessageType type) {
        this.sendMessage(Identity.nil(), message, type);
    }

    default public void sendMessage(@NonNull Identified source, @NonNull Component message, @NonNull MessageType type) {
        this.sendMessage(source.identity(), message, type);
    }

    default public void sendMessage(@NonNull Identity source, @NonNull Component message, @NonNull MessageType type) {
    }

    default public void sendActionBar(@NonNull ComponentLike message) {
        this.sendActionBar(message.asComponent());
    }

    default public void sendActionBar(@NonNull Component message) {
    }

    default public void sendPlayerListHeader(@NonNull ComponentLike header) {
        this.sendPlayerListHeader(header.asComponent());
    }

    default public void sendPlayerListHeader(@NonNull Component header) {
        this.sendPlayerListHeaderAndFooter(header, Component.empty());
    }

    default public void sendPlayerListFooter(@NonNull ComponentLike footer) {
        this.sendPlayerListFooter(footer.asComponent());
    }

    default public void sendPlayerListFooter(@NonNull Component footer) {
        this.sendPlayerListHeaderAndFooter(Component.empty(), footer);
    }

    default public void sendPlayerListHeaderAndFooter(@NonNull ComponentLike header, @NonNull ComponentLike footer) {
        this.sendPlayerListHeaderAndFooter(header.asComponent(), footer.asComponent());
    }

    default public void sendPlayerListHeaderAndFooter(@NonNull Component header, @NonNull Component footer) {
    }

    default public void showTitle(@NonNull Title title) {
    }

    default public void clearTitle() {
    }

    default public void resetTitle() {
    }

    default public void showBossBar(@NonNull BossBar bar) {
    }

    default public void hideBossBar(@NonNull BossBar bar) {
    }

    default public void playSound(@NonNull Sound sound) {
    }

    default public void playSound(@NonNull Sound sound, double x, double y, double z) {
    }

    default public void stopSound(@NonNull SoundStop stop) {
    }

    default public void openBook(@NonNull Book.Builder book) {
        this.openBook(book.build());
    }

    default public void openBook(@NonNull Book book) {
    }
}

