/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.adventure.nbt;

import io.lumine.xikage.mythicmobs.utils.adventure.nbt.BinaryTagIO;
import io.lumine.xikage.mythicmobs.utils.adventure.nbt.BinaryTagTypes;
import io.lumine.xikage.mythicmobs.utils.adventure.nbt.CompoundBinaryTag;
import io.lumine.xikage.mythicmobs.utils.adventure.nbt.IOStreamUtil;
import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.checkerframework.checker.nullness.qual.NonNull;

final class BinaryTagWriterImpl
implements BinaryTagIO.Writer {
    static final BinaryTagIO.Writer INSTANCE = new BinaryTagWriterImpl();

    BinaryTagWriterImpl() {
    }

    @Override
    public void write(@NonNull CompoundBinaryTag tag, @NonNull Path path, @NonNull BinaryTagIO.Compression compression) throws IOException {
        try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
            this.write(tag, os, compression);
        }
    }

    @Override
    public void write(@NonNull CompoundBinaryTag tag, @NonNull OutputStream output, @NonNull BinaryTagIO.Compression compression) throws IOException {
        try (DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(compression.compress(IOStreamUtil.closeShield(output))));){
            this.write(tag, dos);
        }
    }

    @Override
    public void write(@NonNull CompoundBinaryTag tag, @NonNull DataOutput output) throws IOException {
        output.writeByte(BinaryTagTypes.COMPOUND.id());
        output.writeUTF("");
        BinaryTagTypes.COMPOUND.write(tag, output);
    }

    @Override
    public void writeNamed( @NonNull Map.Entry<String, CompoundBinaryTag> tag, @NonNull Path path, @NonNull BinaryTagIO.Compression compression) throws IOException {
        try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
            this.writeNamed(tag, os, compression);
        }
    }

    @Override
    public void writeNamed( @NonNull Map.Entry<String, CompoundBinaryTag> tag, @NonNull OutputStream output, @NonNull BinaryTagIO.Compression compression) throws IOException {
        try (DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(compression.compress(IOStreamUtil.closeShield(output))));){
            this.writeNamed(tag, dos);
        }
    }

    @Override
    public void writeNamed( @NonNull Map.Entry<String, CompoundBinaryTag> tag, @NonNull DataOutput output) throws IOException {
        output.writeByte(BinaryTagTypes.COMPOUND.id());
        output.writeUTF(tag.getKey());
        BinaryTagTypes.COMPOUND.write(tag.getValue(), output);
    }
}

