/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.adventure.nbt;

import io.lumine.xikage.mythicmobs.utils.adventure.nbt.AbstractBinaryTag;
import io.lumine.xikage.mythicmobs.utils.adventure.nbt.BinaryTag;
import io.lumine.xikage.mythicmobs.utils.adventure.nbt.BinaryTagType;
import io.lumine.xikage.mythicmobs.utils.adventure.nbt.BinaryTagTypes;
import io.lumine.xikage.mythicmobs.utils.adventure.nbt.ByteArrayBinaryTag;
import io.lumine.xikage.mythicmobs.utils.adventure.nbt.CompoundBinaryTag;
import io.lumine.xikage.mythicmobs.utils.adventure.nbt.IntArrayBinaryTag;
import io.lumine.xikage.mythicmobs.utils.adventure.nbt.ListBinaryTag;
import io.lumine.xikage.mythicmobs.utils.adventure.nbt.LongArrayBinaryTag;
import io.lumine.xikage.mythicmobs.utils.adventure.nbt.NumberBinaryTag;
import io.lumine.xikage.mythicmobs.utils.adventure.nbt.StringBinaryTag;
import io.lumine.xikage.mythicmobs.utils.text.examination.ExaminableProperty;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.Debug;

@Debug.Renderer(text="\"CompoundBinaryTag[length=\" + this.tags.size() + \"]\"", childrenArray="this.tags.entrySet().toArray()", hasChildren="!this.tags.isEmpty()")
final class CompoundBinaryTagImpl
extends AbstractBinaryTag
implements CompoundBinaryTag {
    static final CompoundBinaryTag EMPTY = new CompoundBinaryTagImpl(Collections.emptyMap());
    private final Map<String, BinaryTag> tags;
    private final int hashCode;

    CompoundBinaryTagImpl(Map<String, BinaryTag> tags) {
        this.tags = Collections.unmodifiableMap(tags);
        this.hashCode = tags.hashCode();
    }

    public boolean contains(@NonNull String key, @NonNull BinaryTagType<?> type) {
        @Nullable BinaryTag tag = this.tags.get(key);
        return tag != null && type.test(tag.type());
    }

    @Override
    public @NonNull Set<String> keySet() {
        return Collections.unmodifiableSet(this.tags.keySet());
    }

    @Override
    public @Nullable BinaryTag get(String key) {
        return this.tags.get(key);
    }

    @Override
    public @NonNull CompoundBinaryTag put(@NonNull String key, @NonNull BinaryTag tag) {
        return this.edit(map -> map.put(key, tag));
    }

    @Override
    public @NonNull CompoundBinaryTag put(@NonNull CompoundBinaryTag tag) {
        return this.edit(map -> {
            for (String key : tag.keySet()) {
                map.put(key, tag.get(key));
            }
        });
    }

    @Override
    public @NonNull CompoundBinaryTag put(@NonNull Map<String, ? extends BinaryTag> tags) {
        return this.edit(map -> map.putAll(tags));
    }

    @Override
    public @NonNull CompoundBinaryTag remove(@NonNull String key, @Nullable Consumer<? super BinaryTag> removed) {
        if (!this.tags.containsKey(key)) {
            return this;
        }
        return this.edit(map -> {
            BinaryTag tag = (BinaryTag)map.remove(key);
            if (removed != null) {
                removed.accept(tag);
            }
        });
    }

    @Override
    public byte getByte(@NonNull String key, byte defaultValue) {
        if (this.contains(key, BinaryTagTypes.BYTE)) {
            return ((NumberBinaryTag)this.tags.get(key)).byteValue();
        }
        return defaultValue;
    }

    @Override
    public short getShort(@NonNull String key, short defaultValue) {
        if (this.contains(key, BinaryTagTypes.SHORT)) {
            return ((NumberBinaryTag)this.tags.get(key)).shortValue();
        }
        return defaultValue;
    }

    @Override
    public int getInt(@NonNull String key, int defaultValue) {
        if (this.contains(key, BinaryTagTypes.INT)) {
            return ((NumberBinaryTag)this.tags.get(key)).intValue();
        }
        return defaultValue;
    }

    @Override
    public long getLong(@NonNull String key, long defaultValue) {
        if (this.contains(key, BinaryTagTypes.LONG)) {
            return ((NumberBinaryTag)this.tags.get(key)).longValue();
        }
        return defaultValue;
    }

    @Override
    public float getFloat(@NonNull String key, float defaultValue) {
        if (this.contains(key, BinaryTagTypes.FLOAT)) {
            return ((NumberBinaryTag)this.tags.get(key)).floatValue();
        }
        return defaultValue;
    }

    @Override
    public double getDouble(@NonNull String key, double defaultValue) {
        if (this.contains(key, BinaryTagTypes.DOUBLE)) {
            return ((NumberBinaryTag)this.tags.get(key)).doubleValue();
        }
        return defaultValue;
    }

    @Override
    public byte @NonNull [] getByteArray(@NonNull String key) {
        if (this.contains(key, BinaryTagTypes.BYTE_ARRAY)) {
            return ((ByteArrayBinaryTag)this.tags.get(key)).value();
        }
        return new byte[0];
    }

    @Override
    public byte @NonNull [] getByteArray(@NonNull String key, byte @NonNull [] defaultValue) {
        if (this.contains(key, BinaryTagTypes.BYTE_ARRAY)) {
            return ((ByteArrayBinaryTag)this.tags.get(key)).value();
        }
        return defaultValue;
    }

    @Override
    public @NonNull String getString(@NonNull String key, @NonNull String defaultValue) {
        if (this.contains(key, BinaryTagTypes.STRING)) {
            return ((StringBinaryTag)this.tags.get(key)).value();
        }
        return defaultValue;
    }

    @Override
    public @NonNull ListBinaryTag getList(@NonNull String key, @NonNull ListBinaryTag defaultValue) {
        if (this.contains(key, BinaryTagTypes.LIST)) {
            return (ListBinaryTag)this.tags.get(key);
        }
        return defaultValue;
    }

    @Override
    public @NonNull ListBinaryTag getList(@NonNull String key, @NonNull BinaryTagType<? extends BinaryTag> expectedType, @NonNull ListBinaryTag defaultValue) {
        ListBinaryTag tag;
        if (this.contains(key, BinaryTagTypes.LIST) && expectedType.test((tag = (ListBinaryTag)this.tags.get(key)).elementType())) {
            return tag;
        }
        return defaultValue;
    }

    @Override
    public @NonNull CompoundBinaryTag getCompound(@NonNull String key, @NonNull CompoundBinaryTag defaultValue) {
        if (this.contains(key, BinaryTagTypes.COMPOUND)) {
            return (CompoundBinaryTag)this.tags.get(key);
        }
        return defaultValue;
    }

    @Override
    public int @NonNull [] getIntArray(@NonNull String key) {
        if (this.contains(key, BinaryTagTypes.INT_ARRAY)) {
            return ((IntArrayBinaryTag)this.tags.get(key)).value();
        }
        return new int[0];
    }

    @Override
    public int @NonNull [] getIntArray(@NonNull String key, int @NonNull [] defaultValue) {
        if (this.contains(key, BinaryTagTypes.INT_ARRAY)) {
            return ((IntArrayBinaryTag)this.tags.get(key)).value();
        }
        return defaultValue;
    }

    @Override
    public long @NonNull [] getLongArray(@NonNull String key) {
        if (this.contains(key, BinaryTagTypes.LONG_ARRAY)) {
            return ((LongArrayBinaryTag)this.tags.get(key)).value();
        }
        return new long[0];
    }

    @Override
    public long @NonNull [] getLongArray(@NonNull String key, long @NonNull [] defaultValue) {
        if (this.contains(key, BinaryTagTypes.LONG_ARRAY)) {
            return ((LongArrayBinaryTag)this.tags.get(key)).value();
        }
        return defaultValue;
    }

    private CompoundBinaryTag edit(Consumer<Map<String, BinaryTag>> consumer) {
        HashMap<String, BinaryTag> tags = new HashMap<String, BinaryTag>(this.tags);
        consumer.accept(tags);
        return new CompoundBinaryTagImpl(tags);
    }

    public boolean equals(Object that) {
        return this == that || that instanceof CompoundBinaryTagImpl && this.tags.equals(((CompoundBinaryTagImpl)that).tags);
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public @NonNull Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("tags", this.tags));
    }

    @Override
    public @NonNull Iterator<Map.Entry<String, ? extends BinaryTag>> iterator() {
        return this.tags.entrySet().iterator();
    }

    @Override
    public void forEach(@NonNull Consumer<? super Map.Entry<String, ? extends BinaryTag>> action) {
        this.tags.entrySet().forEach(Objects.requireNonNull(action, "action"));
    }
}

