/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.adventure.nbt;

import io.lumine.xikage.mythicmobs.utils.adventure.nbt.BinaryTag;
import io.lumine.xikage.mythicmobs.utils.adventure.nbt.CompoundBinaryTag;
import io.lumine.xikage.mythicmobs.utils.adventure.nbt.CompoundBinaryTagImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class CompoundTagBuilder
implements CompoundBinaryTag.Builder {
    private @MonotonicNonNull Map<String, BinaryTag> tags;

    CompoundTagBuilder() {
    }

    private Map<String, BinaryTag> tags() {
        if (this.tags == null) {
            this.tags = new HashMap<String, BinaryTag>();
        }
        return this.tags;
    }

    @Override
    public @NonNull CompoundBinaryTag.Builder put(@NonNull String key, @NonNull BinaryTag tag) {
        this.tags().put(key, tag);
        return this;
    }

    @Override
    public @NonNull CompoundBinaryTag.Builder put(@NonNull CompoundBinaryTag tag) {
        Map<String, BinaryTag> tags = this.tags();
        for (String key : tag.keySet()) {
            tags.put(key, tag.get(key));
        }
        return this;
    }

    @Override
    public @NonNull CompoundBinaryTag.Builder put(@NonNull Map<String, ? extends BinaryTag> tags) {
        this.tags().putAll(tags);
        return this;
    }

    @Override
    public @NonNull CompoundBinaryTag.Builder remove(@NonNull String key, @Nullable Consumer<? super BinaryTag> removed) {
        if (this.tags != null) {
            BinaryTag tag = this.tags.remove(key);
            if (removed != null) {
                removed.accept(tag);
            }
        }
        return this;
    }

    @Override
    public @NonNull CompoundBinaryTag build() {
        if (this.tags == null) {
            return CompoundBinaryTag.empty();
        }
        return new CompoundBinaryTagImpl(new HashMap<String, BinaryTag>(this.tags));
    }
}

