/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.adventure.nbt;

import io.lumine.xikage.mythicmobs.utils.adventure.nbt.BinaryTag;
import io.lumine.xikage.mythicmobs.utils.adventure.nbt.BinaryTagType;
import io.lumine.xikage.mythicmobs.utils.adventure.nbt.BinaryTagTypes;
import io.lumine.xikage.mythicmobs.utils.adventure.nbt.ListBinaryTag;
import io.lumine.xikage.mythicmobs.utils.adventure.nbt.ListBinaryTagImpl;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;

final class ListTagBuilder<T extends BinaryTag>
implements ListBinaryTag.Builder<T> {
    private @MonotonicNonNull List<BinaryTag> tags;
    private BinaryTagType<? extends BinaryTag> elementType;

    ListTagBuilder() {
        this(BinaryTagTypes.END);
    }

    ListTagBuilder(BinaryTagType<? extends BinaryTag> type) {
        this.elementType = type;
    }

    @Override
    public @NonNull ListBinaryTag.Builder<T> add(BinaryTag tag) {
        ListBinaryTagImpl.noAddEnd(tag);
        if (this.elementType == BinaryTagTypes.END) {
            this.elementType = tag.type();
        }
        ListBinaryTagImpl.mustBeSameType(tag, this.elementType);
        if (this.tags == null) {
            this.tags = new ArrayList<BinaryTag>();
        }
        this.tags.add(tag);
        return this;
    }

    @Override
    public @NonNull ListBinaryTag.Builder<T> add(Iterable<? extends T> tagsToAdd) {
        for (BinaryTag tag : tagsToAdd) {
            this.add(tag);
        }
        return this;
    }

    @Override
    public @NonNull ListBinaryTag build() {
        if (this.tags == null) {
            return ListBinaryTag.empty();
        }
        return new ListBinaryTagImpl(this.elementType, new ArrayList<BinaryTag>(this.tags));
    }
}

