/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.adventure.platform.bukkit;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.graph.MutableGraph;
import io.lumine.xikage.mythicmobs.utils.adventure.audience.Audience;
import io.lumine.xikage.mythicmobs.utils.adventure.key.Key;
import io.lumine.xikage.mythicmobs.utils.adventure.platform.bukkit.BukkitAudience;
import io.lumine.xikage.mythicmobs.utils.adventure.platform.bukkit.BukkitAudiences;
import io.lumine.xikage.mythicmobs.utils.adventure.platform.facet.FacetAudienceProvider;
import io.lumine.xikage.mythicmobs.utils.adventure.platform.facet.Knob;
import io.lumine.xikage.mythicmobs.utils.adventure.text.serializer.craftbukkit.MinecraftReflection;
import io.lumine.xikage.mythicmobs.utils.adventure.translation.Translator;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.ProxiedCommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class BukkitAudiencesImpl
extends FacetAudienceProvider<CommandSender, BukkitAudience>
implements BukkitAudiences,
Listener {
    private static final Map<String, BukkitAudiences> INSTANCES;
    private final Plugin plugin;

    static BukkitAudiences instanceFor(@NonNull Plugin plugin) {
        Objects.requireNonNull(plugin, "plugin");
        return INSTANCES.computeIfAbsent(plugin.getName(), name -> new BukkitAudiencesImpl(plugin));
    }

    BukkitAudiencesImpl(@NonNull Plugin plugin) {
        this.plugin = plugin;
        this.softDepend("ViaVersion");
        ConsoleCommandSender console = this.plugin.getServer().getConsoleSender();
        this.addViewer(console);
        this.changeViewer(console, Locale.getDefault());
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            this.addViewer(player);
        }
        this.registerEvent(PlayerJoinEvent.class, EventPriority.LOWEST, event -> this.addViewer(event.getPlayer()));
        this.registerEvent(PlayerQuitEvent.class, EventPriority.MONITOR, event -> this.removeViewer(event.getPlayer()));
        this.registerLocaleEvent(this::changeViewer);
    }

    @Override
    public @NonNull Audience sender(@NonNull CommandSender sender) {
        if (sender instanceof Player) {
            return this.player((Player)sender);
        }
        if (sender instanceof ConsoleCommandSender) {
            return this.console();
        }
        if (sender instanceof ProxiedCommandSender) {
            return this.sender(((ProxiedCommandSender)sender).getCallee());
        }
        if (sender instanceof Entity || sender instanceof Block) {
            return Audience.empty();
        }
        return this.createAudience(Collections.singletonList(sender));
    }

    @Override
    public @NonNull Audience player(@NonNull Player player) {
        return this.player(player.getUniqueId());
    }

    @Override
    protected @Nullable UUID hasId(@NonNull CommandSender viewer) {
        if (viewer instanceof Player) {
            return ((Player)viewer).getUniqueId();
        }
        return null;
    }

    @Override
    protected boolean isConsole(@NonNull CommandSender viewer) {
        return viewer instanceof ConsoleCommandSender;
    }

    @Override
    protected boolean hasPermission(@NonNull CommandSender viewer, @NonNull String permission) {
        return viewer.hasPermission(permission);
    }

    @Override
    protected boolean isInWorld(@NonNull CommandSender viewer, @NonNull Key world) {
        if (viewer instanceof Player) {
            return ((Player)viewer).getWorld().getName().equals(world.value());
        }
        return false;
    }

    @Override
    protected boolean isOnServer(@NonNull CommandSender viewer, @NonNull String server) {
        return false;
    }

    @Override
    protected @NonNull BukkitAudience createAudience(@NonNull Collection<CommandSender> viewers) {
        return new BukkitAudience(this.plugin, viewers, null);
    }

    private void softDepend(@NonNull String pluginName) {
        PluginDescriptionFile file = this.plugin.getDescription();
        if (file.getName().equals(pluginName)) {
            return;
        }
        try {
            Field softDepend = MinecraftReflection.needField(file.getClass(), "softDepend");
            List dependencies = (List)softDepend.get(file);
            if (!dependencies.contains(pluginName)) {
                ImmutableCollection newList = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll((Iterable)dependencies)).add(pluginName)).build();
                softDepend.set(file, newList);
            }
        }
        catch (Throwable error) {
            Knob.logError(error, "Failed to inject softDepend in plugin.yml: %s %s", this.plugin, pluginName);
        }
        try {
            PluginManager manager = this.plugin.getServer().getPluginManager();
            Field dependencyGraphField = MinecraftReflection.needField(manager.getClass(), "dependencyGraph");
            MutableGraph graph = (MutableGraph)dependencyGraphField.get(manager);
            graph.putEdge(file.getName(), pluginName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private <T extends Event> void registerEvent(@NonNull Class<T> type, @NonNull EventPriority priority, @NonNull Consumer<T> callback) {
        Objects.requireNonNull(callback, "callback");
        this.plugin.getServer().getPluginManager().registerEvent(type, (Listener)this, priority, (listener, event) -> callback.accept(event), this.plugin, true);
    }

    private void registerLocaleEvent(@NonNull BiConsumer<Player, Locale> callback) {
        MethodHandle getMethod;
        Class<?> eventClass = MinecraftReflection.findClass("org.bukkit.event.player.PlayerLocaleChangeEvent");
        if (eventClass == null) {
            eventClass = MinecraftReflection.findClass("com.destroystokyo.paper.event.player.PlayerLocaleChangeEvent");
        }
        if ((getMethod = MinecraftReflection.findMethod(eventClass, "getLocale", String.class, new Class[0])) == null) {
            getMethod = MinecraftReflection.findMethod(eventClass, "getNewLocale", String.class, new Class[0]);
        }
        if (getMethod != null && PlayerEvent.class.isAssignableFrom(eventClass)) {
            Class<?> localeEvent = eventClass;
            MethodHandle getLocale = getMethod;
            this.registerEvent(localeEvent, EventPriority.MONITOR, event -> {
                String locale;
                Player player = event.getPlayer();
                try {
                    locale = getLocale.invoke((PlayerEvent)event);
                }
                catch (Throwable error) {
                    Knob.logError(error, "Failed to accept %s: %s", localeEvent.getName(), player);
                    return;
                }
                callback.accept(player, BukkitAudiencesImpl.toLocale(locale));
            });
        }
    }

    private static @NonNull Locale toLocale(@Nullable String string) {
        Locale locale;
        if (string != null && (locale = Translator.parseLocale(string)) != null) {
            return locale;
        }
        return Locale.US;
    }

    static {
        Knob.OUT = message -> Bukkit.getLogger().log(Level.INFO, (String)message);
        Knob.ERR = (message, error) -> Bukkit.getLogger().log(Level.WARNING, (String)message, (Throwable)error);
        INSTANCES = Collections.synchronizedMap(new HashMap(4));
    }
}

