/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.adventure.platform.bukkit;

import com.destroystokyo.paper.Title;
import io.lumine.xikage.mythicmobs.utils.adventure.platform.bukkit.CraftBukkitFacet;
import io.lumine.xikage.mythicmobs.utils.adventure.platform.bukkit.SpigotFacet;
import io.lumine.xikage.mythicmobs.utils.adventure.platform.facet.Facet;
import io.lumine.xikage.mythicmobs.utils.adventure.platform.facet.FacetBase;
import io.lumine.xikage.mythicmobs.utils.adventure.platform.facet.Knob;
import io.lumine.xikage.mythicmobs.utils.adventure.text.Component;
import io.lumine.xikage.mythicmobs.utils.adventure.text.serializer.craftbukkit.MinecraftReflection;
import io.lumine.xikage.mythicmobs.utils.adventure.text.serializer.gson.GsonComponentSerializer;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

class PaperFacet<V extends CommandSender>
extends FacetBase<V> {
    private static final boolean SUPPORTED = Knob.isEnabled("paper", true);
    static final Class<?> NATIVE_COMPONENT_CLASS = MinecraftReflection.findClass(String.join((CharSequence)".", "net", "kyori", "adventure", "text", "Component"));
    private static final Class<?> NATIVE_GSON_COMPONENT_SERIALIZER_CLASS = MinecraftReflection.findClass(String.join((CharSequence)".", "net", "kyori", "adventure", "text", "serializer", "gson", "GsonComponentSerializer"));
    private static final Class<?> NATIVE_GSON_COMPONENT_SERIALIZER_IMPL_CLASS = MinecraftReflection.findClass(String.join((CharSequence)".", "net", "kyori", "adventure", "text", "serializer", "gson", "GsonComponentSerializerImpl"));
    private static final MethodHandle NATIVE_GSON_COMPONENT_SERIALIZER_GSON_GETTER = MinecraftReflection.findStaticMethod(NATIVE_GSON_COMPONENT_SERIALIZER_CLASS, "gson", NATIVE_GSON_COMPONENT_SERIALIZER_CLASS, new Class[0]);
    private static final MethodHandle NATIVE_GSON_COMPONENT_SERIALIZER_DESERIALIZE_METHOD = PaperFacet.findNativeDeserializeMethod();

    private static @Nullable MethodHandle findNativeDeserializeMethod() {
        try {
            Method method = NATIVE_GSON_COMPONENT_SERIALIZER_IMPL_CLASS.getDeclaredMethod("deserialize", String.class);
            method.setAccessible(true);
            return MinecraftReflection.lookup().unreflect(method);
        }
        catch (IllegalAccessException | NoSuchMethodException | NullPointerException e) {
            return null;
        }
    }

    protected PaperFacet(@Nullable Class<? extends V> viewerClass) {
        super(viewerClass);
    }

    @Override
    public boolean isSupported() {
        return super.isSupported() && SUPPORTED;
    }

    static class TabList
    extends CraftBukkitFacet.TabList {
        private static final boolean SUPPORTED = MinecraftReflection.hasField(CLASS_CRAFT_PLAYER, "playerListHeader", NATIVE_COMPONENT_CLASS) && MinecraftReflection.hasField(CLASS_CRAFT_PLAYER, "playerListFooter", NATIVE_COMPONENT_CLASS);
        private static final MethodHandle NATIVE_GSON_COMPONENT_SERIALIZER_DESERIALIZE_METHOD_BOUND = TabList.createBoundNativeDeserializeMethodHandle();

        TabList() {
        }

        private static @Nullable MethodHandle createBoundNativeDeserializeMethodHandle() {
            if (SUPPORTED) {
                try {
                    return NATIVE_GSON_COMPONENT_SERIALIZER_DESERIALIZE_METHOD.bindTo(NATIVE_GSON_COMPONENT_SERIALIZER_GSON_GETTER.invoke());
                }
                catch (Throwable throwable) {
                    Knob.logError(throwable, "Failed to access native GsonComponentSerializer", new Object[0]);
                    return null;
                }
            }
            return null;
        }

        @Override
        public boolean isSupported() {
            return SUPPORTED && super.isSupported();
        }

        @Override
        public @Nullable Object createMessage(@NonNull Player viewer, @NonNull Component message) {
            try {
                return NATIVE_GSON_COMPONENT_SERIALIZER_DESERIALIZE_METHOD_BOUND.invoke((String)GsonComponentSerializer.gson().serialize(message));
            }
            catch (Throwable throwable) {
                Knob.logError(throwable, "Failed to create native Component message", new Object[0]);
                return null;
            }
        }
    }

    static class Title
    extends SpigotFacet.Message<Player>
    implements Facet.Title<Player, BaseComponent[], com.destroystokyo.paper.Title> {
        private static final boolean SUPPORTED = MinecraftReflection.hasClass("com.destroystokyo.paper.Title");

        protected Title() {
            super(Player.class);
        }

        @Override
        public boolean isSupported() {
            return super.isSupported() && SUPPORTED;
        }

        @Override
        public @NonNull com.destroystokyo.paper.Title createTitle(BaseComponent @Nullable [] title, BaseComponent @Nullable [] subTitle, int inTicks, int stayTicks, int outTicks) {
            Title.Builder builder = com.destroystokyo.paper.Title.builder();
            if (title != null) {
                builder.title(title);
            }
            if (subTitle != null) {
                builder.subtitle(subTitle);
            }
            if (inTicks > -1) {
                builder.fadeIn(inTicks);
            }
            if (stayTicks > -1) {
                builder.stay(stayTicks);
            }
            if (outTicks > -1) {
                builder.fadeOut(outTicks);
            }
            return builder.build();
        }

        @Override
        public void showTitle(@NonNull Player viewer, @NonNull com.destroystokyo.paper.Title title) {
            viewer.sendTitle(title);
        }

        @Override
        public void clearTitle(@NonNull Player viewer) {
            viewer.hideTitle();
        }

        @Override
        public void resetTitle(@NonNull Player viewer) {
            viewer.resetTitle();
        }
    }
}

