/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.adventure.platform.facet;

import io.lumine.xikage.mythicmobs.utils.adventure.audience.MessageType;
import io.lumine.xikage.mythicmobs.utils.adventure.bossbar.BossBar;
import io.lumine.xikage.mythicmobs.utils.adventure.identity.Identity;
import io.lumine.xikage.mythicmobs.utils.adventure.platform.facet.Knob;
import io.lumine.xikage.mythicmobs.utils.adventure.sound.SoundStop;
import io.lumine.xikage.mythicmobs.utils.adventure.text.Component;
import java.io.Closeable;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface Facet<V> {
    @SafeVarargs
    public static <V, F extends Facet<? extends V>> @NonNull Collection<F> of(Supplier<F> ... suppliers) {
        LinkedList<Facet> facets = new LinkedList<Facet>();
        for (Supplier<F> supplier : suppliers) {
            Facet facet;
            try {
                facet = (Facet)supplier.get();
            }
            catch (NoClassDefFoundError error) {
                Knob.logMessage("Skipped facet: %s", supplier.getClass().getName());
                continue;
            }
            catch (Throwable error) {
                Knob.logError(error, "Failed facet: %s", supplier);
                continue;
            }
            if (!facet.isSupported()) {
                Knob.logMessage("Skipped facet: %s", facet);
                continue;
            }
            facets.add(facet);
            Knob.logMessage("Added facet: %s", facet);
        }
        return facets;
    }

    public static <V, F extends Facet<V>> @Nullable F of(@Nullable Collection<F> facets, @Nullable V viewer) {
        if (facets == null || viewer == null) {
            return null;
        }
        for (Facet facet : facets) {
            try {
                if (!facet.isApplicable(viewer)) continue;
                Knob.logMessage("Selected facet: %s for %s", facet, viewer);
                return (F)facet;
            }
            catch (ClassCastException classCastException) {
            }
        }
        return null;
    }

    default public boolean isSupported() {
        return true;
    }

    default public boolean isApplicable(@NonNull V viewer) {
        return true;
    }

    public static interface TabList<V, M>
    extends Message<V, M> {
        public void send(V var1, @Nullable M var2, @Nullable M var3);
    }

    public static interface FakeEntity<V, P>
    extends Position<V, P>,
    Closeable {
        public void teleport(@NonNull V var1, @Nullable P var2);

        public void metadata(int var1, @NonNull Object var2);

        public void invisible(boolean var1);

        public void health(float var1);

        public void name(@NonNull Component var1);

        @Override
        public void close();
    }

    public static interface BossBarEntity<V, P>
    extends BossBar<V>,
    FakeEntity<V, P> {
        public static final int OFFSET_PITCH = 30;
        public static final int OFFSET_YAW = 0;
        public static final int OFFSET_MAGNITUDE = 40;
        public static final int INVULNERABLE_KEY = 20;
        public static final int INVULNERABLE_TICKS = 890;

        @Override
        default public void bossBarProgressChanged(@NonNull io.lumine.xikage.mythicmobs.utils.adventure.bossbar.BossBar bar, float oldProgress, float newProgress) {
            this.health(newProgress);
        }

        @Override
        default public void bossBarNameChanged(@NonNull io.lumine.xikage.mythicmobs.utils.adventure.bossbar.BossBar bar, @NonNull Component oldName, @NonNull Component newName) {
            this.name(newName);
        }

        @Override
        default public void addViewer(@NonNull V viewer) {
            this.teleport(viewer, this.createPosition(viewer));
        }

        @Override
        default public void removeViewer(@NonNull V viewer) {
            this.teleport(viewer, null);
        }
    }

    public static interface BossBarPacket<V>
    extends BossBar<V> {
        public static final int ACTION_ADD = 0;
        public static final int ACTION_REMOVE = 1;
        public static final int ACTION_HEALTH = 2;
        public static final int ACTION_TITLE = 3;
        public static final int ACTION_STYLE = 4;
        public static final int ACTION_FLAG = 5;

        default public int createColor(@NonNull BossBar.Color color) {
            if (color == BossBar.Color.PURPLE) {
                return 5;
            }
            if (color == BossBar.Color.PINK) {
                return 0;
            }
            if (color == BossBar.Color.BLUE) {
                return 1;
            }
            if (color == BossBar.Color.RED) {
                return 2;
            }
            if (color == BossBar.Color.GREEN) {
                return 3;
            }
            if (color == BossBar.Color.YELLOW) {
                return 4;
            }
            if (color == BossBar.Color.WHITE) {
                return 6;
            }
            Knob.logUnsupported(this, (Object)color);
            return 5;
        }

        default public int createOverlay(@NonNull BossBar.Overlay overlay) {
            if (overlay == BossBar.Overlay.PROGRESS) {
                return 0;
            }
            if (overlay == BossBar.Overlay.NOTCHED_6) {
                return 1;
            }
            if (overlay == BossBar.Overlay.NOTCHED_10) {
                return 2;
            }
            if (overlay == BossBar.Overlay.NOTCHED_12) {
                return 3;
            }
            if (overlay == BossBar.Overlay.NOTCHED_20) {
                return 4;
            }
            Knob.logUnsupported(this, (Object)overlay);
            return 0;
        }

        default public byte createFlag(byte flagBit, @NonNull Set<BossBar.Flag> flagsAdded, @NonNull Set<BossBar.Flag> flagsRemoved) {
            byte bit = flagBit;
            for (BossBar.Flag flag : flagsAdded) {
                if (flag == BossBar.Flag.DARKEN_SCREEN) {
                    bit = (byte)(bit | 1);
                    continue;
                }
                if (flag == BossBar.Flag.PLAY_BOSS_MUSIC) {
                    bit = (byte)(bit | 2);
                    continue;
                }
                if (flag == BossBar.Flag.CREATE_WORLD_FOG) {
                    bit = (byte)(bit | 4);
                    continue;
                }
                Knob.logUnsupported(this, (Object)flag);
            }
            for (BossBar.Flag flag : flagsRemoved) {
                if (flag == BossBar.Flag.DARKEN_SCREEN) {
                    bit = (byte)(bit & 0xFFFFFFFE);
                    continue;
                }
                if (flag == BossBar.Flag.PLAY_BOSS_MUSIC) {
                    bit = (byte)(bit & 0xFFFFFFFD);
                    continue;
                }
                if (flag == BossBar.Flag.CREATE_WORLD_FOG) {
                    bit = (byte)(bit & 0xFFFFFFFB);
                    continue;
                }
                Knob.logUnsupported(this, (Object)flag);
            }
            return bit;
        }
    }

    public static interface BossBar<V>
    extends BossBar.Listener,
    Closeable {
        public static final int PROTOCOL_BOSS_BAR = 356;

        default public void bossBarInitialized(@NonNull io.lumine.xikage.mythicmobs.utils.adventure.bossbar.BossBar bar) {
            this.bossBarNameChanged(bar, bar.name(), bar.name());
            this.bossBarColorChanged(bar, bar.color(), bar.color());
            this.bossBarProgressChanged(bar, bar.progress(), bar.progress());
            this.bossBarFlagsChanged(bar, bar.flags(), Collections.emptySet());
            this.bossBarOverlayChanged(bar, bar.overlay(), bar.overlay());
        }

        public void addViewer(@NonNull V var1);

        public void removeViewer(@NonNull V var1);

        public boolean isEmpty();

        @Override
        public void close();

        @FunctionalInterface
        public static interface Builder<V, B extends BossBar<V>>
        extends Facet<V> {
            public @NonNull B createBossBar(@NonNull Collection<V> var1);
        }
    }

    public static interface Book<V, M, B>
    extends Message<V, M> {
        public @Nullable B createBook(@NonNull M var1, @NonNull M var2, @NonNull Iterable<M> var3);

        public void openBook(@NonNull V var1, @NonNull B var2);
    }

    public static interface Sound<V, P>
    extends Position<V, P> {
        public void playSound(@NonNull V var1, @NonNull io.lumine.xikage.mythicmobs.utils.adventure.sound.Sound var2, @NonNull P var3);

        public void stopSound(@NonNull V var1, @NonNull SoundStop var2);
    }

    public static interface Position<V, P>
    extends Facet<V> {
        public @Nullable P createPosition(@NonNull V var1);

        public @NonNull P createPosition(double var1, double var3, double var5);
    }

    public static interface TitlePacket<V, M, T>
    extends Title<V, M, T> {
        public static final int ACTION_TITLE = 0;
        public static final int ACTION_SUBTITLE = 1;
        public static final int ACTION_ACTIONBAR = 2;
        public static final int ACTION_TIMES = 3;
        public static final int ACTION_CLEAR = 4;
        public static final int ACTION_RESET = 5;
    }

    public static interface Title<V, M, T>
    extends Message<V, M> {
        public static final int PROTOCOL_ACTION_BAR = 310;
        public static final long MAX_SECONDS = 0x666666666666666L;

        public @Nullable T createTitle(@Nullable M var1, @Nullable M var2, int var3, int var4, int var5);

        public void showTitle(@NonNull V var1, @NonNull T var2);

        public void clearTitle(@NonNull V var1);

        public void resetTitle(@NonNull V var1);

        default public int toTicks(@Nullable Duration duration) {
            if (duration == null || duration.isNegative()) {
                return -1;
            }
            if (duration.getSeconds() > 0x666666666666666L) {
                return Integer.MAX_VALUE;
            }
            return (int)(duration.getSeconds() * 20L + (long)(duration.getNano() / 50000000));
        }
    }

    public static interface ActionBar<V, M>
    extends Message<V, M> {
        public void sendMessage(@NonNull V var1, @NonNull M var2);
    }

    public static interface ChatPacket<V, M>
    extends Chat<V, M> {
        public static final byte TYPE_CHAT = 0;
        public static final byte TYPE_SYSTEM = 1;
        public static final byte TYPE_ACTION_BAR = 2;

        default public byte createMessageType(@NonNull MessageType type) {
            if (type == MessageType.CHAT) {
                return 0;
            }
            if (type == MessageType.SYSTEM) {
                return 1;
            }
            Knob.logUnsupported(this, (Object)type);
            return 0;
        }
    }

    public static interface Chat<V, M>
    extends Message<V, M> {
        public void sendMessage(@NonNull V var1, @NonNull Identity var2, @NonNull M var3, @NonNull MessageType var4);
    }

    public static interface Message<V, M>
    extends Facet<V> {
        public static final int PROTOCOL_HEX_COLOR = 713;
        public static final int PROTOCOL_JSON = 5;

        public @Nullable M createMessage(@NonNull V var1, @NonNull Component var2);
    }
}

