/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.adventure.platform.facet;

import io.lumine.xikage.mythicmobs.utils.adventure.audience.Audience;
import io.lumine.xikage.mythicmobs.utils.adventure.audience.MessageType;
import io.lumine.xikage.mythicmobs.utils.adventure.bossbar.BossBar;
import io.lumine.xikage.mythicmobs.utils.adventure.identity.Identity;
import io.lumine.xikage.mythicmobs.utils.adventure.inventory.Book;
import io.lumine.xikage.mythicmobs.utils.adventure.platform.facet.Facet;
import io.lumine.xikage.mythicmobs.utils.adventure.platform.facet.FacetBossBarListener;
import io.lumine.xikage.mythicmobs.utils.adventure.sound.Sound;
import io.lumine.xikage.mythicmobs.utils.adventure.sound.SoundStop;
import io.lumine.xikage.mythicmobs.utils.adventure.text.Component;
import io.lumine.xikage.mythicmobs.utils.adventure.title.Title;
import io.lumine.xikage.mythicmobs.utils.adventure.translation.GlobalTranslator;
import java.io.Closeable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FacetAudience<V>
implements Audience,
Closeable {
    private final @NonNull Set<V> viewers = new CopyOnWriteArraySet<V>();
    private volatile @Nullable V viewer;
    private volatile @NonNull Locale locale;
    private final @Nullable Facet.Chat<V, Object> chat;
    private final @Nullable Facet.ActionBar<V, Object> actionBar;
    private final @Nullable Facet.Title<V, Object, Object> title;
    private final @Nullable Facet.Sound<V, Object> sound;
    private final @Nullable Facet.Book<V, Object, Object> book;
    private final @Nullable Facet.BossBar.Builder<V, Facet.BossBar<V>> bossBar;
    private final @Nullable Map<BossBar, Facet.BossBar<V>> bossBars;
    private final @Nullable Facet.TabList<V, Object> tabList;

    public FacetAudience(@NonNull Collection<? extends V> viewers, @Nullable Locale locale, @Nullable Collection<? extends Facet.Chat> chat, @Nullable Collection<? extends Facet.ActionBar> actionBar, @Nullable Collection<? extends Facet.Title> title, @Nullable Collection<? extends Facet.Sound> sound, @Nullable Collection<? extends Facet.Book> book, @Nullable Collection<? extends Facet.BossBar.Builder> bossBar, @Nullable Collection<? extends Facet.TabList> tabList) {
        this.locale = locale == null ? Locale.US : locale;
        for (V viewer : Objects.requireNonNull(viewers, "viewers")) {
            this.addViewer(viewer);
        }
        this.chat = Facet.of(chat, this.viewer);
        this.actionBar = Facet.of(actionBar, this.viewer);
        this.title = Facet.of(title, this.viewer);
        this.sound = Facet.of(sound, this.viewer);
        this.book = Facet.of(book, this.viewer);
        this.bossBar = Facet.of(bossBar, this.viewer);
        this.bossBars = this.bossBar == null ? null : Collections.synchronizedMap(new IdentityHashMap(4));
        this.tabList = Facet.of(tabList, this.viewer);
    }

    public void addViewer(@NonNull V viewer) {
        if (this.viewers.add(viewer) && this.viewer == null) {
            this.viewer = viewer;
        }
    }

    public void removeViewer(@NonNull V viewer) {
        if (this.viewers.remove(viewer) && this.viewer == viewer) {
            this.viewer = this.viewers.isEmpty() ? null : this.viewers.iterator().next();
            Object v0 = this.viewer;
        }
        if (this.bossBars == null) {
            return;
        }
        for (Facet.BossBar<V> listener : this.bossBars.values()) {
            listener.removeViewer(viewer);
        }
    }

    public void changeLocale(@NonNull Locale locale) {
        this.locale = Objects.requireNonNull(locale, "locale");
    }

    @Override
    public void sendMessage(@NonNull Identity source, @NonNull Component original, @NonNull MessageType type) {
        if (this.chat == null) {
            return;
        }
        Object message = this.createMessage(original, this.chat);
        if (message == null) {
            return;
        }
        for (V viewer : this.viewers) {
            this.chat.sendMessage(viewer, source, message, type);
        }
    }

    @Override
    public void sendActionBar(@NonNull Component original) {
        if (this.actionBar == null) {
            return;
        }
        Object message = this.createMessage(original, this.actionBar);
        if (message == null) {
            return;
        }
        for (V viewer : this.viewers) {
            this.actionBar.sendMessage(viewer, message);
        }
    }

    @Override
    public void playSound(@NonNull Sound original) {
        if (this.sound == null) {
            return;
        }
        for (V viewer : this.viewers) {
            Object position = this.sound.createPosition(viewer);
            if (position == null) continue;
            this.sound.playSound(viewer, original, position);
        }
    }

    @Override
    public void playSound(@NonNull Sound original, double x, double y, double z) {
        if (this.sound == null) {
            return;
        }
        Object position = this.sound.createPosition(x, y, z);
        for (V viewer : this.viewers) {
            this.sound.playSound(viewer, original, position);
        }
    }

    @Override
    public void stopSound(@NonNull SoundStop original) {
        if (this.sound == null) {
            return;
        }
        for (V viewer : this.viewers) {
            this.sound.stopSound(viewer, original);
        }
    }

    @Override
    public void openBook(@NonNull Book original) {
        if (this.book == null) {
            return;
        }
        Object title = this.createMessage(original.title(), this.book);
        Object author = this.createMessage(original.author(), this.book);
        LinkedList<Object> pages = new LinkedList<Object>();
        for (Component originalPage : original.pages()) {
            Object page = this.createMessage(originalPage, this.book);
            if (page == null) continue;
            pages.add(page);
        }
        if (title == null || author == null || pages.isEmpty()) {
            return;
        }
        Object book = this.book.createBook(title, author, pages);
        if (book == null) {
            return;
        }
        for (V viewer : this.viewers) {
            this.book.openBook(viewer, book);
        }
    }

    @Override
    public void showTitle(@NonNull Title original) {
        int outTicks;
        int stayTicks;
        Title.Times times;
        int inTicks;
        Object subTitle;
        if (this.title == null) {
            return;
        }
        Object mainTitle = this.createMessage(original.title(), this.title);
        Object title = this.title.createTitle(mainTitle, subTitle = this.createMessage(original.subtitle(), this.title), inTicks = (times = original.times()) == null ? -1 : this.title.toTicks(times.fadeIn()), stayTicks = times == null ? -1 : this.title.toTicks(times.stay()), outTicks = times == null ? -1 : this.title.toTicks(times.fadeOut()));
        if (title == null) {
            return;
        }
        for (V viewer : this.viewers) {
            this.title.showTitle(viewer, title);
        }
    }

    @Override
    public void clearTitle() {
        if (this.title == null) {
            return;
        }
        for (V viewer : this.viewers) {
            this.title.clearTitle(viewer);
        }
    }

    @Override
    public void resetTitle() {
        if (this.title == null) {
            return;
        }
        for (V viewer : this.viewers) {
            this.title.resetTitle(viewer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showBossBar(@NonNull BossBar bar) {
        Facet.BossBar listener;
        if (this.bossBars == null) {
            return;
        }
        Map<BossBar, Facet.BossBar<V>> map = this.bossBars;
        synchronized (map) {
            listener = this.bossBars.get(bar);
            if (listener == null) {
                listener = new FacetBossBarListener<V>(this.bossBar.createBossBar(this.viewers), () -> this.locale);
                this.bossBars.put(bar, listener);
            }
        }
        if (listener.isEmpty()) {
            listener.bossBarInitialized(bar);
            bar.addListener(listener);
        }
        for (Object viewer : this.viewers) {
            listener.addViewer(viewer);
        }
    }

    @Override
    public void hideBossBar(@NonNull BossBar bar) {
        if (this.bossBars == null) {
            return;
        }
        Facet.BossBar<V> listener = this.bossBars.get(bar);
        if (listener == null) {
            return;
        }
        for (V viewer : this.viewers) {
            listener.removeViewer(viewer);
        }
        if (listener.isEmpty() && this.bossBars.remove(bar) != null) {
            bar.removeListener(listener);
            listener.close();
        }
    }

    @Override
    public void sendPlayerListHeader(@NonNull Component header) {
        if (this.tabList != null) {
            Object headerFormatted = this.createMessage(header, this.tabList);
            if (headerFormatted == null) {
                return;
            }
            for (V viewer : this.viewers) {
                this.tabList.send(viewer, headerFormatted, null);
            }
        }
    }

    @Override
    public void sendPlayerListFooter(@NonNull Component footer) {
        if (this.tabList != null) {
            Object footerFormatted = this.createMessage(footer, this.tabList);
            if (footerFormatted == null) {
                return;
            }
            for (V viewer : this.viewers) {
                this.tabList.send(viewer, null, footerFormatted);
            }
        }
    }

    @Override
    public void sendPlayerListHeaderAndFooter(@NonNull Component header, @NonNull Component footer) {
        if (this.tabList != null) {
            Object headerFormatted = this.createMessage(header, this.tabList);
            Object footerFormatted = this.createMessage(footer, this.tabList);
            if (headerFormatted == null || footerFormatted == null) {
                return;
            }
            for (V viewer : this.viewers) {
                this.tabList.send(viewer, headerFormatted, footerFormatted);
            }
        }
    }

    @Override
    public void close() {
        if (this.bossBars != null) {
            for (BossBar bar : new HashSet<BossBar>(this.bossBars.keySet())) {
                this.hideBossBar(bar);
            }
            this.bossBars.clear();
        }
        for (Object viewer : this.viewers) {
            this.removeViewer(viewer);
        }
        this.viewers.clear();
    }

    private @Nullable Object createMessage(@NonNull Component original, @NonNull Facet.Message<V, Object> facet) {
        Component message = GlobalTranslator.render(original, this.locale);
        V viewer = this.viewer;
        return viewer == null ? null : facet.createMessage(viewer, message);
    }
}

