/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.adventure.text.minimessage;

import io.lumine.xikage.mythicmobs.utils.adventure.text.Component;
import io.lumine.xikage.mythicmobs.utils.adventure.text.ComponentLike;
import io.lumine.xikage.mythicmobs.utils.adventure.text.TextComponent;
import io.lumine.xikage.mythicmobs.utils.adventure.text.minimessage.DebugContext;
import io.lumine.xikage.mythicmobs.utils.adventure.text.minimessage.MiniMessageImpl;
import io.lumine.xikage.mythicmobs.utils.adventure.text.minimessage.ParseException;
import io.lumine.xikage.mythicmobs.utils.adventure.text.minimessage.Template;
import io.lumine.xikage.mythicmobs.utils.adventure.text.minimessage.parser.MiniMessageLexer;
import io.lumine.xikage.mythicmobs.utils.adventure.text.minimessage.parser.ParsingException;
import io.lumine.xikage.mythicmobs.utils.adventure.text.minimessage.parser.Token;
import io.lumine.xikage.mythicmobs.utils.adventure.text.minimessage.parser.TokenType;
import io.lumine.xikage.mythicmobs.utils.adventure.text.minimessage.transformation.Inserting;
import io.lumine.xikage.mythicmobs.utils.adventure.text.minimessage.transformation.InstantApplyTransformation;
import io.lumine.xikage.mythicmobs.utils.adventure.text.minimessage.transformation.OneTimeTransformation;
import io.lumine.xikage.mythicmobs.utils.adventure.text.minimessage.transformation.Transformation;
import io.lumine.xikage.mythicmobs.utils.adventure.text.minimessage.transformation.TransformationRegistry;
import io.lumine.xikage.mythicmobs.utils.adventure.text.minimessage.transformation.inbuild.PreTransformation;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;

class MiniMessageParser {
    private static final String START = "start";
    private static final String TOKEN = "token";
    private static final String INNER = "inner";
    private static final String END = "end";
    private static final Pattern pattern = Pattern.compile("((?<start><)(?<token>[^<>]+(:(?<inner>['\"]?([^'\"](\\\\['\"])?)+['\"]?))*)(?<end>>))+?");
    private final TransformationRegistry registry;
    private final Function<String, ComponentLike> placeholderResolver;

    MiniMessageParser() {
        this.registry = new TransformationRegistry();
        this.placeholderResolver = MiniMessageImpl.DEFAULT_PLACEHOLDER_RESOLVER;
    }

    MiniMessageParser(TransformationRegistry registry, Function<String, ComponentLike> placeholderResolver) {
        this.registry = registry;
        this.placeholderResolver = placeholderResolver;
    }

    @NonNull String escapeTokens(@NonNull String richMessage) {
        StringBuilder sb = new StringBuilder();
        Matcher matcher = pattern.matcher(richMessage);
        int lastEnd = 0;
        while (matcher.find()) {
            int startIndex = matcher.start();
            int endIndex = matcher.end();
            if (startIndex > lastEnd) {
                sb.append(richMessage, lastEnd, startIndex);
            }
            lastEnd = endIndex;
            String start = matcher.group(START);
            String token = matcher.group(TOKEN);
            String inner = matcher.group(INNER);
            String end = matcher.group(END);
            if (inner != null) {
                token = token.replace(inner, this.escapeTokens(inner));
            }
            sb.append("\\").append(start).append(token).append(end);
        }
        if (richMessage.length() > lastEnd) {
            sb.append(richMessage.substring(lastEnd));
        }
        return sb.toString();
    }

    @NonNull String stripTokens(@NonNull String richMessage) {
        StringBuilder sb = new StringBuilder();
        Matcher matcher = pattern.matcher(richMessage);
        int lastEnd = 0;
        while (matcher.find()) {
            int startIndex = matcher.start();
            int endIndex = matcher.end();
            if (startIndex > lastEnd) {
                sb.append(richMessage, lastEnd, startIndex);
            }
            lastEnd = endIndex;
        }
        if (richMessage.length() > lastEnd) {
            sb.append(richMessage.substring(lastEnd));
        }
        return sb.toString();
    }

    @NonNull String handlePlaceholders(@NonNull String richMessage, @NonNull DebugContext debugContext, String ... placeholders) {
        if (placeholders.length % 2 != 0) {
            throw new ParseException("Invalid number placeholders defined, usage: parseFormat(format, key, value, key, value...)");
        }
        for (int i = 0; i < placeholders.length; i += 2) {
            richMessage = richMessage.replace("<" + placeholders[i] + ">", placeholders[i + 1]);
        }
        debugContext.replacedMessage(richMessage);
        return richMessage;
    }

    @NonNull String handlePlaceholders(@NonNull String richMessage, @NonNull DebugContext debugContext, @NonNull Map<String, String> placeholders) {
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            richMessage = richMessage.replace("<" + entry.getKey() + ">", entry.getValue());
        }
        debugContext.replacedMessage(richMessage);
        return richMessage;
    }

    @NonNull Component parseFormat(@NonNull String richMessage, @NonNull DebugContext debugContext, String ... placeholders) {
        return this.parseFormat(this.handlePlaceholders(richMessage, debugContext, placeholders), debugContext);
    }

    @NonNull Component parseFormat(@NonNull String richMessage, @NonNull Map<String, String> placeholders, DebugContext debugContext) {
        return this.parseFormat(this.handlePlaceholders(richMessage, debugContext, placeholders), debugContext);
    }

    @NonNull Component parseFormat(@NonNull String input, DebugContext debugContext, Template ... placeholders) {
        HashMap<String, Template.ComponentTemplate> map = new HashMap<String, Template.ComponentTemplate>();
        for (Template placeholder : placeholders) {
            if (placeholder instanceof Template.StringTemplate) {
                Template.StringTemplate stringTemplate = (Template.StringTemplate)placeholder;
                input = input.replace("<" + stringTemplate.key() + ">", stringTemplate.value());
                continue;
            }
            if (!(placeholder instanceof Template.ComponentTemplate)) continue;
            Template.ComponentTemplate componentTemplate = (Template.ComponentTemplate)placeholder;
            map.put(componentTemplate.key(), componentTemplate);
        }
        return this.parseFormat0(input, map, debugContext);
    }

    @NonNull Component parseFormat(@NonNull String input, @NonNull List<Template> placeholders, @NonNull DebugContext debugContext) {
        HashMap<String, Template.ComponentTemplate> map = new HashMap<String, Template.ComponentTemplate>();
        for (Template placeholder : placeholders) {
            if (placeholder instanceof Template.StringTemplate) {
                Template.StringTemplate stringTemplate = (Template.StringTemplate)placeholder;
                input = input.replace("<" + stringTemplate.key() + ">", stringTemplate.value());
                continue;
            }
            if (!(placeholder instanceof Template.ComponentTemplate)) continue;
            Template.ComponentTemplate componentTemplate = (Template.ComponentTemplate)placeholder;
            map.put(componentTemplate.key(), componentTemplate);
        }
        return this.parseFormat0(input, map, debugContext);
    }

    @NonNull Component parseFormat(@NonNull String richMessage, @NonNull DebugContext debugContext) {
        return this.parseFormat0(richMessage, Collections.emptyMap(), debugContext);
    }

    @NonNull Component parseFormat0(@NonNull String richMessage, @NonNull Map<String, Template.ComponentTemplate> templates, @NonNull DebugContext debugContext) {
        return this.parseFormat0(richMessage, templates, this.registry, this.placeholderResolver, debugContext);
    }

    @NonNull Component parseFormat0(@NonNull String richMessage, @NonNull Map<String, Template.ComponentTemplate> templates, @NonNull TransformationRegistry registry, @NonNull Function<String, ComponentLike> placeholderResolver, DebugContext debugContext) {
        MiniMessageLexer lexer = new MiniMessageLexer(richMessage, debugContext);
        try {
            lexer.scan();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        lexer.clean();
        List<Token> tokens = lexer.getTokens();
        debugContext.tokens(tokens);
        return this.parse(tokens, registry, templates, placeholderResolver, debugContext);
    }

    @NonNull Component parse(@NonNull List<Token> tokens, @NonNull TransformationRegistry registry, @NonNull Map<String, Template.ComponentTemplate> templates, @NonNull Function<String, ComponentLike> placeholderResolver, @NonNull DebugContext debugContext) {
        TextComponent.Builder parent = Component.text();
        ArrayDeque<Transformation> transformations = new ArrayDeque<Transformation>();
        ArrayDeque<OneTimeTransformation> oneTimeTransformations = new ArrayDeque<OneTimeTransformation>();
        boolean preActive = false;
        int i = 0;
        block4: while (i < tokens.size()) {
            Token token = tokens.get(i);
            switch (token.type()) {
                case ESCAPED_OPEN_TAG_START: 
                case OPEN_TAG_START: {
                    String string;
                    Transformation transformation3;
                    Token next;
                    ArrayList<Token> inners;
                    Object paramOrEnd;
                    Token name;
                    if (tokens.size() - 1 == i) {
                        if (debugContext.isStrict()) {
                            throw new ParsingException("Expected name after open tag, but got nothing", -1);
                        }
                        tokens.set(i, new Token(TokenType.STRING, token.value()));
                        continue block4;
                    }
                    if ((name = tokens.get(++i)).type() == TokenType.OPEN_TAG_START && token.type() == TokenType.ESCAPED_OPEN_TAG_START) {
                        tokens.set(--i, new Token(TokenType.STRING, name.value()));
                        continue block4;
                    }
                    if (name.type() != TokenType.NAME && token.type() != TokenType.ESCAPED_OPEN_TAG_START) {
                        if (debugContext.isStrict()) {
                            throw new ParsingException("Expected name after open tag, but got " + name, -1);
                        }
                        debugContext.miniMessage().parsingErrorMessageConsumer().accept(Collections.singletonList("Expected name after open tag, but got " + name));
                        continue block4;
                    }
                    if (tokens.size() - 1 == i) {
                        if (debugContext.isStrict()) {
                            throw new ParsingException("Expected param or end after open tag + name, but got nothing", -1);
                        }
                        debugContext.miniMessage().parsingErrorMessageConsumer().accept(Collections.singletonList("Expected param or end after open tag + name, but got nothing"));
                        continue block4;
                    }
                    if (((Token)(paramOrEnd = tokens.get(++i))).type() == TokenType.PARAM_SEPARATOR) {
                        inners = new ArrayList<Token>();
                        next = null;
                        while (i < tokens.size() - 1 && (next = tokens.get(++i)).type() != TokenType.TAG_END) {
                            inners.add(next);
                        }
                        if (next == null) {
                            if (debugContext.isStrict()) {
                                throw new ParsingException("Expected end sometimes after open tag + name, but got name = " + name + " and inners = " + inners, -1);
                            }
                            debugContext.miniMessage().parsingErrorMessageConsumer().accept(Collections.singletonList("Expected end sometimes after open tag + name, but got name = " + name + " and inners = " + inners));
                            continue block4;
                        }
                        transformation3 = registry.get(name.value(), inners, templates, placeholderResolver, debugContext);
                        if (transformation3 == null || preActive || token.type() == TokenType.ESCAPED_OPEN_TAG_START) {
                            StringBuilder string2 = new StringBuilder(tokens.get(i -= 3 + inners.size()).value()).append(name.value()).append(((Token)paramOrEnd).value());
                            inners.forEach(t -> string2.append(t.value()));
                            string2.append(next.value());
                            tokens.set(i, new Token(TokenType.STRING, string2.toString()));
                            for (int c = 0; c < inners.size() + 3; ++c) {
                                tokens.remove(i + 1);
                            }
                            continue block4;
                        }
                        if (transformation3 instanceof InstantApplyTransformation) {
                            ((InstantApplyTransformation)transformation3).applyInstant(parent, transformations);
                            break;
                        }
                        if (transformation3 instanceof OneTimeTransformation) {
                            oneTimeTransformations.addLast((OneTimeTransformation)transformation3);
                            break;
                        }
                        if (transformation3 instanceof PreTransformation) {
                            preActive = true;
                        }
                        transformations.addLast(transformation3);
                        break;
                    }
                    if (((Token)paramOrEnd).type() == TokenType.TAG_END || ((Token)paramOrEnd).type() == TokenType.ESCAPED_CLOSE_TAG_START) {
                        Transformation transformation2 = registry.get(name.value(), Collections.emptyList(), templates, placeholderResolver, debugContext);
                        if (transformation2 == null || preActive || token.type() == TokenType.ESCAPED_OPEN_TAG_START) {
                            string = tokens.get(i -= 2).value() + name.value() + ((Token)paramOrEnd).value();
                            tokens.set(i, new Token(TokenType.STRING, string));
                            tokens.remove(i + 1);
                            tokens.remove(i + 1);
                            continue block4;
                        }
                        if (transformation2 instanceof InstantApplyTransformation) {
                            ((InstantApplyTransformation)transformation2).applyInstant(parent, transformations);
                            break;
                        }
                        if (transformation2 instanceof OneTimeTransformation) {
                            oneTimeTransformations.addLast((OneTimeTransformation)transformation2);
                            break;
                        }
                        if (transformation2 instanceof PreTransformation) {
                            preActive = true;
                        }
                        transformations.addLast(transformation2);
                        break;
                    }
                    if (debugContext.isStrict()) {
                        throw new ParsingException("Expected tag end or param separator after tag name, but got " + paramOrEnd, -1);
                    }
                    debugContext.miniMessage().parsingErrorMessageConsumer().accept(Collections.singletonList("Expected tag end or param separator after tag name, but got " + paramOrEnd));
                    continue block4;
                }
                case ESCAPED_CLOSE_TAG_START: 
                case CLOSE_TAG_START: {
                    String string;
                    Transformation transformation3;
                    Token next;
                    ArrayList<Token> inners;
                    Object paramOrEnd;
                    Token name;
                    if (tokens.size() - 1 == i) {
                        if (debugContext.isStrict()) {
                            throw new ParsingException("Expected name after open tag, but got nothing", -1);
                        }
                        tokens.set(i, new Token(TokenType.STRING, token.value()));
                        continue block4;
                    }
                    if ((name = tokens.get(++i)).type() != TokenType.NAME && token.type() != TokenType.ESCAPED_CLOSE_TAG_START) {
                        if (debugContext.isStrict()) {
                            throw new ParsingException("Expected name after close tag start, but got " + name, -1);
                        }
                        debugContext.miniMessage().parsingErrorMessageConsumer().accept(Collections.singletonList("Expected name after close tag start, but got " + name));
                        continue block4;
                    }
                    if (tokens.size() - 1 == i) {
                        if (debugContext.isStrict()) {
                            throw new ParsingException("Expected param or end after open tag + name, but got nothing", -1);
                        }
                        debugContext.miniMessage().parsingErrorMessageConsumer().accept(Collections.singletonList("Expected param or end after open tag + name, but got nothing"));
                        continue block4;
                    }
                    if (((Token)(paramOrEnd = tokens.get(++i))).type() == TokenType.TAG_END) {
                        if (!registry.exists(name.value()) || preActive && !name.value().equalsIgnoreCase("pre") || token.type() == TokenType.ESCAPED_CLOSE_TAG_START) {
                            String string3 = tokens.get(i -= 2).value() + name.value() + ((Token)paramOrEnd).value();
                            tokens.set(i, new Token(TokenType.STRING, string3));
                            tokens.remove(i + 1);
                            tokens.remove(i + 1);
                            continue block4;
                        }
                        Transformation removed = this.removeFirst(transformations, t -> t.name().equals(name.value()));
                        if (removed instanceof PreTransformation) {
                            preActive = false;
                            break;
                        }
                        if (removed != null || registry.couldBeOnetimeTransformation(name.value())) break;
                        string = tokens.get(i -= 2).value() + name.value() + ((Token)paramOrEnd).value();
                        tokens.set(i, new Token(TokenType.STRING, string));
                        tokens.remove(i + 1);
                        tokens.remove(i + 1);
                        --i;
                        break;
                    }
                    if (((Token)paramOrEnd).type() == TokenType.PARAM_SEPARATOR) {
                        inners = new ArrayList();
                        while ((next = tokens.get(++i)).type() != TokenType.TAG_END) {
                            inners.add(next);
                        }
                        transformation3 = registry.get(name.value(), inners, templates, placeholderResolver, debugContext);
                        transformations.removeFirstOccurrence(transformation3);
                        break;
                    }
                    if (debugContext.isStrict()) {
                        throw new ParsingException("Expected tag end or param separator after tag name, but got " + paramOrEnd, -1);
                    }
                    debugContext.miniMessage().parsingErrorMessageConsumer().accept(Collections.singletonList("Expected tag end or param separator after tag name, but got " + paramOrEnd));
                    continue block4;
                }
                default: {
                    Transformation transformation3;
                    Component current = Component.text(token.value());
                    for (Transformation transformation3 : transformations) {
                        current = transformation3.apply(current, parent);
                    }
                    while (!oneTimeTransformations.isEmpty()) {
                        current = ((OneTimeTransformation)oneTimeTransformations.removeLast()).applyOneTime(current, parent, transformations);
                    }
                    if (current == null) break;
                    parent.append(current);
                }
            }
            ++i;
        }
        List<Component> children = parent.asComponent().children();
        TextComponent last = children.isEmpty() ? Component.empty() : children.get(children.size() - 1);
        for (Transformation transformation2 : transformations) {
            if (!(transformation2 instanceof Inserting)) continue;
            transformation2.apply(last, parent);
        }
        while (!oneTimeTransformations.isEmpty()) {
            ((OneTimeTransformation)oneTimeTransformations.removeFirst()).applyOneTime(last, parent, transformations);
        }
        TextComponent comp = (TextComponent)parent.build();
        if (comp.content().equals("") && comp.children().size() == 1) {
            return comp.children().get(0);
        }
        return comp;
    }

    private Transformation removeFirst(Deque<Transformation> transformations, Predicate<Transformation> filter) {
        Iterator<Transformation> each = transformations.descendingIterator();
        while (each.hasNext()) {
            Transformation next = each.next();
            if (!filter.test(next)) continue;
            each.remove();
            return next;
        }
        return null;
    }
}

