/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.adventure.text.minimessage;

import io.lumine.xikage.mythicmobs.utils.adventure.key.Key;
import io.lumine.xikage.mythicmobs.utils.adventure.text.Component;
import io.lumine.xikage.mythicmobs.utils.adventure.text.KeybindComponent;
import io.lumine.xikage.mythicmobs.utils.adventure.text.TextComponent;
import io.lumine.xikage.mythicmobs.utils.adventure.text.TranslatableComponent;
import io.lumine.xikage.mythicmobs.utils.adventure.text.event.ClickEvent;
import io.lumine.xikage.mythicmobs.utils.adventure.text.event.HoverEvent;
import io.lumine.xikage.mythicmobs.utils.adventure.text.format.NamedTextColor;
import io.lumine.xikage.mythicmobs.utils.adventure.text.format.TextColor;
import io.lumine.xikage.mythicmobs.utils.adventure.text.format.TextDecoration;
import java.util.ArrayList;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class MiniMessageSerializer {
    private MiniMessageSerializer() {
    }

    static @NonNull String serialize(@NonNull Component component) {
        StringBuilder sb = new StringBuilder();
        ArrayList<Component> components = new ArrayList<Component>();
        components.add(component);
        for (int i = 0; i < components.size(); ++i) {
            Key font;
            String insert;
            ClickEvent click;
            HoverEvent<?> hov;
            Component comp = (Component)components.get(i);
            components.addAll(i + 1, comp.children());
            Component prevComp = null;
            if (i > 0) {
                prevComp = (Component)components.get(i - 1);
            }
            if (!(NamedTextColor.WHITE.equals(comp.color()) || comp.color() == null || prevComp != null && prevComp.color() == comp.color())) {
                sb.append(MiniMessageSerializer.startColor(Objects.requireNonNull(comp.color())));
            }
            if (comp.hasDecoration(TextDecoration.BOLD) && (prevComp == null || !prevComp.hasDecoration(TextDecoration.BOLD))) {
                sb.append(MiniMessageSerializer.startTag("bold"));
            }
            if (comp.hasDecoration(TextDecoration.ITALIC) && (prevComp == null || !prevComp.hasDecoration(TextDecoration.ITALIC))) {
                sb.append(MiniMessageSerializer.startTag("italic"));
            }
            if (comp.hasDecoration(TextDecoration.OBFUSCATED) && (prevComp == null || !prevComp.hasDecoration(TextDecoration.OBFUSCATED))) {
                sb.append(MiniMessageSerializer.startTag("obfuscated"));
            }
            if (comp.hasDecoration(TextDecoration.STRIKETHROUGH) && (prevComp == null || !prevComp.hasDecoration(TextDecoration.STRIKETHROUGH))) {
                sb.append(MiniMessageSerializer.startTag("strikethrough"));
            }
            if (comp.hasDecoration(TextDecoration.UNDERLINED) && (prevComp == null || !prevComp.hasDecoration(TextDecoration.UNDERLINED))) {
                sb.append(MiniMessageSerializer.startTag("underlined"));
            }
            if ((hov = comp.hoverEvent()) != null && (prevComp == null || MiniMessageSerializer.areDifferent(hov, prevComp.hoverEvent())) && hov.value() instanceof Component) {
                sb.append(MiniMessageSerializer.startTag(String.format("%s:%s:\"%s\"", "hover", HoverEvent.Action.NAMES.key(hov.action()), MiniMessageSerializer.serialize((Component)hov.value()))));
            }
            if ((click = comp.clickEvent()) != null && (prevComp == null || MiniMessageSerializer.areDifferent(click, prevComp.clickEvent()))) {
                sb.append(MiniMessageSerializer.startTag(String.format("%s:%s:\"%s\"", "click", ClickEvent.Action.NAMES.key(click.action()), click.value())));
            }
            if (!((insert = comp.insertion()) == null || prevComp != null && insert.equals(prevComp.insertion()))) {
                sb.append(MiniMessageSerializer.startTag("insert:" + insert));
            }
            if (!((font = comp.style().font()) == null || prevComp != null && font.equals(prevComp.style().font()))) {
                sb.append(MiniMessageSerializer.startTag("font:" + font.asString()));
            }
            if (comp instanceof TextComponent) {
                sb.append(((TextComponent)comp).content());
            } else {
                MiniMessageSerializer.handleDifferentComponent(comp, sb);
            }
            Component nextComp = null;
            if (i + 1 < components.size()) {
                nextComp = (Component)components.get(i + 1);
            }
            if (nextComp != null && comp.color() != NamedTextColor.WHITE && comp.color() != null && (nextComp.color() == NamedTextColor.WHITE || nextComp.color() == null)) {
                sb.append(MiniMessageSerializer.endColor(Objects.requireNonNull(comp.color())));
            }
            if (nextComp != null) {
                if (comp.hasDecoration(TextDecoration.BOLD) && !nextComp.hasDecoration(TextDecoration.BOLD)) {
                    sb.append(MiniMessageSerializer.endTag("bold"));
                }
                if (comp.hasDecoration(TextDecoration.ITALIC) && !nextComp.hasDecoration(TextDecoration.ITALIC)) {
                    sb.append(MiniMessageSerializer.endTag("italic"));
                }
                if (comp.hasDecoration(TextDecoration.OBFUSCATED) && !nextComp.hasDecoration(TextDecoration.OBFUSCATED)) {
                    sb.append(MiniMessageSerializer.endTag("obfuscated"));
                }
                if (comp.hasDecoration(TextDecoration.STRIKETHROUGH) && !nextComp.hasDecoration(TextDecoration.STRIKETHROUGH)) {
                    sb.append(MiniMessageSerializer.endTag("strikethrough"));
                }
                if (comp.hasDecoration(TextDecoration.UNDERLINED) && !nextComp.hasDecoration(TextDecoration.UNDERLINED)) {
                    sb.append(MiniMessageSerializer.endTag("underlined"));
                }
            }
            if (nextComp != null && comp.hoverEvent() != null && MiniMessageSerializer.areDifferent(Objects.requireNonNull(comp.hoverEvent()), nextComp.hoverEvent())) {
                sb.append(MiniMessageSerializer.endTag("hover"));
            }
            if (nextComp != null && comp.clickEvent() != null && MiniMessageSerializer.areDifferent(Objects.requireNonNull(comp.clickEvent()), nextComp.clickEvent())) {
                sb.append(MiniMessageSerializer.endTag("click"));
            }
            if (nextComp != null && comp.insertion() != null && !Objects.equals(comp.insertion(), nextComp.insertion())) {
                sb.append(MiniMessageSerializer.endTag("insert"));
            }
            if (nextComp == null || comp.style().font() == null || Objects.equals(comp.style().font(), nextComp.style().font())) continue;
            sb.append(MiniMessageSerializer.endTag("font"));
        }
        return sb.toString();
    }

    private static boolean areDifferent(@NonNull ClickEvent c1, @Nullable ClickEvent c2) {
        if (c2 == null) {
            return true;
        }
        return !c1.equals(c2) && (!c1.action().equals((Object)c2.action()) || !c1.value().equals(c2.value()));
    }

    private static boolean areDifferent(@NonNull HoverEvent<?> h1, @Nullable HoverEvent<?> h2) {
        if (h2 == null) {
            return true;
        }
        return !h1.equals(h2) && !h1.action().equals(h2.action());
    }

    private static @NonNull String startColor(@NonNull TextColor color) {
        if (color instanceof NamedTextColor) {
            return MiniMessageSerializer.startTag(Objects.requireNonNull(NamedTextColor.NAMES.key((NamedTextColor)color)));
        }
        return MiniMessageSerializer.startTag("color:" + color.asHexString());
    }

    private static @NonNull String endColor(@NonNull TextColor color) {
        if (color instanceof NamedTextColor) {
            return MiniMessageSerializer.endTag(Objects.requireNonNull(NamedTextColor.NAMES.key((NamedTextColor)color)));
        }
        return MiniMessageSerializer.endTag("color:" + color.asHexString());
    }

    private static @NonNull String startTag(@NonNull String content) {
        return "<" + content + ">";
    }

    private static @NonNull String endTag(@NonNull String content) {
        return "</" + content + ">";
    }

    private static void handleDifferentComponent(@NonNull Component component, @NonNull StringBuilder sb) {
        if (component instanceof KeybindComponent) {
            sb.append(MiniMessageSerializer.startTag("key:" + ((KeybindComponent)component).keybind()));
        } else if (component instanceof TranslatableComponent) {
            sb.append(MiniMessageSerializer.startTag("lang:" + ((TranslatableComponent)component).key()));
        }
    }
}

