/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.adventure.text.minimessage.parser;

import io.lumine.xikage.mythicmobs.utils.adventure.text.minimessage.parser.TokenType;
import io.lumine.xikage.mythicmobs.utils.text.examination.Examinable;
import io.lumine.xikage.mythicmobs.utils.text.examination.ExaminableProperty;
import io.lumine.xikage.mythicmobs.utils.text.examination.string.StringExaminer;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class Token
implements Examinable {
    private final String value;
    private final TokenType type;

    public Token(TokenType type) {
        this(type, type.value());
    }

    public Token(String value) {
        this(TokenType.STRING, value);
    }

    public Token(TokenType type, String value) {
        this.type = type;
        this.value = value;
    }

    public TokenType type() {
        return this.type;
    }

    public String value() {
        return this.value;
    }

    public static boolean oneString(List<Token> tokens) {
        return tokens.size() == 1 && tokens.get(0).type() == TokenType.STRING;
    }

    public static String asValueString(List<Token> args) {
        return args.stream().map(Token::value).collect(Collectors.joining());
    }

    @Override
    public @NonNull Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("type", (Object)this.type), ExaminableProperty.of("value", this.value));
    }

    public String toString() {
        return this.examine(StringExaminer.simpleEscaping());
    }
}

