/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.adventure.text.minimessage.transformation.inbuild;

import io.lumine.xikage.mythicmobs.utils.adventure.text.Component;
import io.lumine.xikage.mythicmobs.utils.adventure.text.TextComponent;
import io.lumine.xikage.mythicmobs.utils.adventure.text.format.NamedTextColor;
import io.lumine.xikage.mythicmobs.utils.adventure.text.format.TextColor;
import io.lumine.xikage.mythicmobs.utils.adventure.text.minimessage.parser.ParsingException;
import io.lumine.xikage.mythicmobs.utils.adventure.text.minimessage.parser.Token;
import io.lumine.xikage.mythicmobs.utils.adventure.text.minimessage.transformation.Transformation;
import io.lumine.xikage.mythicmobs.utils.adventure.text.minimessage.transformation.TransformationParser;
import io.lumine.xikage.mythicmobs.utils.text.examination.ExaminableProperty;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ColorTransformation
extends Transformation {
    private TextColor color;

    public static boolean canParse(String name) {
        return name.equalsIgnoreCase("color") || name.equalsIgnoreCase("colour") || name.equalsIgnoreCase("c") || TextColor.fromHexString(name) != null || NamedTextColor.NAMES.value(name.toLowerCase(Locale.ROOT)) != null;
    }

    private ColorTransformation() {
    }

    @Override
    public void load(String name, List<Token> args) {
        super.load(name, args);
        if (name.equalsIgnoreCase("color")) {
            if (Token.oneString(args)) {
                name = args.get(0).value();
            } else {
                throw new ParsingException("Expected to find a color parameter, but found " + args, -1);
            }
        }
        this.color = name.charAt(0) == '#' ? TextColor.fromHexString(name) : (TextColor)NamedTextColor.NAMES.value(name.toLowerCase(Locale.ROOT));
        if (this.color == null) {
            throw new ParsingException("Don't know how to turn '" + name + "' into a color", -1);
        }
    }

    @Override
    public Component apply(Component component, TextComponent.Builder parent) {
        return component.color(this.color);
    }

    @Override
    public @NonNull Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("color", this.color));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ColorTransformation that = (ColorTransformation)other;
        return Objects.equals(this.color, that.color);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.color);
    }

    public static class Parser
    implements TransformationParser<ColorTransformation> {
        @Override
        public ColorTransformation parse() {
            return new ColorTransformation();
        }
    }
}

