/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.adventure.text.minimessage.transformation.inbuild;

import io.lumine.xikage.mythicmobs.utils.adventure.text.Component;
import io.lumine.xikage.mythicmobs.utils.adventure.text.TextComponent;
import io.lumine.xikage.mythicmobs.utils.adventure.text.event.HoverEvent;
import io.lumine.xikage.mythicmobs.utils.adventure.text.minimessage.MiniMessage;
import io.lumine.xikage.mythicmobs.utils.adventure.text.minimessage.parser.ParsingException;
import io.lumine.xikage.mythicmobs.utils.adventure.text.minimessage.parser.Token;
import io.lumine.xikage.mythicmobs.utils.adventure.text.minimessage.parser.TokenType;
import io.lumine.xikage.mythicmobs.utils.adventure.text.minimessage.transformation.Transformation;
import io.lumine.xikage.mythicmobs.utils.adventure.text.minimessage.transformation.TransformationParser;
import io.lumine.xikage.mythicmobs.utils.text.examination.ExaminableProperty;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class HoverTransformation
extends Transformation {
    private HoverEvent.Action<Object> action;
    private Object value;

    public static boolean canParse(String name) {
        return name.equalsIgnoreCase("hover");
    }

    private HoverTransformation() {
    }

    @Override
    public void load(String name, List<Token> args) {
        super.load(name, args);
        if (args.size() < 3 || args.get(0).type() != TokenType.STRING) {
            throw new ParsingException("Doesn't know how to turn " + args + " into a hover event", -1);
        }
        this.action = HoverEvent.Action.NAMES.value(args.get(0).value());
        String string = Token.asValueString(args.subList(2, args.size()));
        if (string.startsWith("'") || string.startsWith("\"")) {
            string = string.substring(1).substring(0, string.length() - 2);
        }
        this.value = MiniMessage.get().parse(string);
    }

    @Override
    public Component apply(Component component, TextComponent.Builder parent) {
        return component.hoverEvent(HoverEvent.hoverEvent(this.action, this.value));
    }

    @Override
    public @NonNull Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("action", this.action), ExaminableProperty.of("value", this.value));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        HoverTransformation that = (HoverTransformation)other;
        return Objects.equals(this.action, that.action) && Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.action, this.value);
    }

    public static class Parser
    implements TransformationParser<HoverTransformation> {
        @Override
        public HoverTransformation parse() {
            return new HoverTransformation();
        }
    }
}

