/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.adventure.text.minimessage.transformation.inbuild;

import io.lumine.xikage.mythicmobs.utils.adventure.text.Component;
import io.lumine.xikage.mythicmobs.utils.adventure.text.TextComponent;
import io.lumine.xikage.mythicmobs.utils.adventure.text.minimessage.Template;
import io.lumine.xikage.mythicmobs.utils.adventure.text.minimessage.transformation.Inserting;
import io.lumine.xikage.mythicmobs.utils.adventure.text.minimessage.transformation.OneTimeTransformation;
import io.lumine.xikage.mythicmobs.utils.adventure.text.minimessage.transformation.Transformation;
import io.lumine.xikage.mythicmobs.utils.text.examination.ExaminableProperty;
import java.util.Deque;
import java.util.Objects;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class TemplateTransformation
extends OneTimeTransformation
implements Inserting {
    private final Template.ComponentTemplate template;

    public TemplateTransformation(@NonNull Template.ComponentTemplate template) {
        this.template = template;
    }

    @Override
    public Component applyOneTime(@NonNull Component current, @NonNull TextComponent.Builder parent, @NonNull Deque<Transformation> transformations) {
        Component comp = this.template.value();
        for (Transformation transformation : transformations) {
            comp = transformation.apply(comp, parent);
        }
        comp = this.merge(this.template.value(), comp);
        parent.append(comp);
        return current;
    }

    @Override
    public @NonNull Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("template", this.template));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TemplateTransformation that = (TemplateTransformation)other;
        return Objects.equals(this.template, that.template);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.template);
    }
}

