/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.command;

import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.SimplePluginManager;

public final class CommandMapUtil {
    private static final Constructor<PluginCommand> COMMAND_CONSTRUCTOR;
    private static final Field COMMAND_MAP_FIELD;
    private static final Field KNOWN_COMMANDS_FIELD;

    private static CommandMap getCommandMap() {
        try {
            return (CommandMap)COMMAND_MAP_FIELD.get(Bukkit.getServer().getPluginManager());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get CommandMap", e);
        }
    }

    private static Map<String, Command> getKnownCommandMap() {
        try {
            return (Map)KNOWN_COMMANDS_FIELD.get(CommandMapUtil.getCommandMap());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get known commands map", e);
        }
    }

    @Nonnull
    public static <T extends CommandExecutor> T registerCommand(@Nonnull Plugin plugin, @Nonnull T command, String ... aliases) {
        return CommandMapUtil.registerCommand(plugin, command, null, null, null, aliases);
    }

    @Nonnull
    public static <T extends CommandExecutor> T registerCommand(@Nonnull Plugin plugin, @Nonnull T command, String permission, String permissionMessage, String description, String ... aliases) {
        Preconditions.checkArgument(aliases.length != 0, "No aliases");
        for (String alias : aliases) {
            try {
                PluginCommand cmd = COMMAND_CONSTRUCTOR.newInstance(alias, plugin);
                CommandMapUtil.getCommandMap().register(plugin.getDescription().getName(), (Command)cmd);
                CommandMapUtil.getKnownCommandMap().put(plugin.getDescription().getName().toLowerCase() + ":" + alias.toLowerCase(), (Command)cmd);
                CommandMapUtil.getKnownCommandMap().put(alias.toLowerCase(), (Command)cmd);
                cmd.setLabel(alias.toLowerCase());
                if (permission != null) {
                    cmd.setPermission(permission);
                    if (permissionMessage != null) {
                        cmd.setPermissionMessage(permissionMessage);
                    }
                }
                if (description != null) {
                    cmd.setDescription(description);
                }
                cmd.setExecutor(command);
                if (!(command instanceof TabCompleter)) continue;
                cmd.setTabCompleter((TabCompleter)command);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return command;
    }

    @Nonnull
    public static <T extends CommandExecutor> T unregisterCommand(@Nonnull T command) {
        CommandMap map = CommandMapUtil.getCommandMap();
        try {
            Map knownCommands = (Map)KNOWN_COMMANDS_FIELD.get(map);
            Iterator iterator = knownCommands.values().iterator();
            while (iterator.hasNext()) {
                CommandExecutor executor;
                Command cmd = (Command)iterator.next();
                if (!(cmd instanceof PluginCommand) || command != (executor = ((PluginCommand)cmd).getExecutor())) continue;
                cmd.unregister(map);
                iterator.remove();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not unregister command", e);
        }
        return command;
    }

    private CommandMapUtil() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }

    static {
        Field knownCommandsField;
        Field commandMapField;
        Constructor commandConstructor;
        try {
            commandConstructor = PluginCommand.class.getDeclaredConstructor(String.class, Plugin.class);
            commandConstructor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        COMMAND_CONSTRUCTOR = commandConstructor;
        try {
            commandMapField = SimplePluginManager.class.getDeclaredField("commandMap");
            commandMapField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        COMMAND_MAP_FIELD = commandMapField;
        try {
            knownCommandsField = SimpleCommandMap.class.getDeclaredField("knownCommands");
            knownCommandsField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        KNOWN_COMMANDS_FIELD = knownCommandsField;
    }
}

