/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.config;

import io.lumine.xikage.mythicmobs.utils.logging.Log;
import io.lumine.xikage.mythicmobs.utils.serialize.Locus;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.ChatColor;

public class LineConfig {
    private String fileName = "Unknown";
    private String key;
    private String line;
    private HashMap<String, String> config = new HashMap();

    public static LineConfig of(String line) {
        return new LineConfig(line);
    }

    public LineConfig(String fileName, String line) {
        this(line);
        this.fileName = fileName;
    }

    public LineConfig(File file, String line) {
        this(line);
        this.fileName = file.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LineConfig(String s2) {
        this.line = LineConfig.unparseBlock(s2);
        s2 = LineConfig.parseBlock(s2);
        if (s2.contains("{") && s2.contains("}")) {
            this.key = s2.substring(0, s2.indexOf("{"));
            int startPos = s2.indexOf(123) + 1;
            int lastPos = s2.lastIndexOf(125);
            int count = 0;
            s2 = s2.substring(startPos, lastPos);
            for (char c : s2.toCharArray()) {
                if (c == '{') {
                    ++count;
                }
                if (c != '}') continue;
                --count;
            }
            if (count != 0) {
                Log.error("Could not load line due to unbalanced braces.");
                return;
            }
            if (s2.length() == 0) {
                return;
            }
            int start = 0;
            int pos = 0;
            int depth = 0;
            String lastKey = "";
            String lastVal = "";
            boolean inb = false;
            s2 = s2 + "}";
            for (char c : s2.toCharArray()) {
                if (c == '{' || c == '[') {
                    ++depth;
                }
                if (c == '}' || c == ']') {
                    --depth;
                }
                if (c == ';' && depth == 0 || c == '}' && depth < 0) {
                    try {
                        String element = s2.substring(start, pos);
                        if (pos - start > 0 && element.length() > 0) {
                            String key = element.substring(0, element.indexOf(61)).trim().toLowerCase();
                            String val = element.substring(element.indexOf(61) + 1).trim();
                            this.config.put(key, val);
                        }
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        start = pos + 1;
                    }
                }
                ++pos;
            }
        } else if (s2.contains("[") && s2.contains("]")) {
            try {
                String[] split = s2.split("\\[");
                s2 = split[1];
                String[] split2 = s2.split("\\]");
                s2 = split2[0];
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                Log.error("Could not load LineConfig: Invalid syntax. String = {0}", s2);
                return;
            }
        } else {
            this.key = s2;
        }
    }

    public String getLine() {
        return this.line;
    }

    public int size() {
        return this.config.size();
    }

    public Set<Map.Entry<String, String>> entrySet() {
        return this.config.entrySet();
    }

    public static String getKey(String s2) {
        String key = null;
        key = s2.contains("{") ? s2.substring(0, s2.indexOf("{")) : (s2.contains("[") ? s2.substring(0, s2.indexOf("[")) : s2);
        return key;
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean def) {
        String s2 = this.config.get(key = key.toLowerCase());
        if (s2 == null) {
            return def;
        }
        try {
            return Boolean.parseBoolean(s2);
        }
        catch (Exception ex) {
            return def;
        }
    }

    public boolean getBoolean(String[] key, boolean def) {
        String k;
        String s2 = null;
        String[] stringArray = key;
        int n = stringArray.length;
        for (int i = 0; i < n && (s2 = this.config.get((k = stringArray[i]).toLowerCase())) == null; ++i) {
        }
        if (s2 == null) {
            return def;
        }
        try {
            return Boolean.parseBoolean(s2);
        }
        catch (Exception ex) {
            return def;
        }
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String[] key) {
        return this.getString(key, null, new String[0]);
    }

    public String getString(String key, String def) {
        String s2 = this.config.get(key.toLowerCase());
        if (s2 == null) {
            return def;
        }
        return s2;
    }

    public String getString(String[] key, String def, String ... args) {
        String s2 = null;
        for (String k : key) {
            s2 = this.config.get(k.toLowerCase());
            if (s2 == null) continue;
            return s2;
        }
        for (String a2 : args) {
            if (a2 == null) continue;
            return a2;
        }
        return def;
    }

    public int getInteger(String key) {
        return this.getInteger(key, 0);
    }

    public int getInteger(String[] key) {
        return this.getInteger(key, 0);
    }

    public int getInteger(String key, int def) {
        String s2 = this.config.get(key.toLowerCase());
        if (s2 == null) {
            return def;
        }
        try {
            return Integer.parseInt(s2);
        }
        catch (Exception ex) {
            return def;
        }
    }

    public int getInteger(String[] key, int def) {
        String k;
        String s2 = null;
        String[] stringArray = key;
        int n = stringArray.length;
        for (int i = 0; i < n && (s2 = this.config.get((k = stringArray[i]).toLowerCase())) == null; ++i) {
        }
        if (s2 == null) {
            return def;
        }
        try {
            return Integer.parseInt(s2);
        }
        catch (Exception ex) {
            return def;
        }
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String[] key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String key, double def) {
        String s2 = this.config.get(key.toLowerCase());
        if (s2 == null) {
            return def;
        }
        try {
            return Double.parseDouble(s2);
        }
        catch (Exception ex) {
            return def;
        }
    }

    public double getDouble(String[] key, double def) {
        String k;
        String s2 = null;
        String[] stringArray = key;
        int n = stringArray.length;
        for (int i = 0; i < n && (s2 = this.config.get((k = stringArray[i]).toLowerCase())) == null; ++i) {
        }
        if (s2 == null) {
            return def;
        }
        try {
            return Double.parseDouble(s2);
        }
        catch (Exception ex) {
            return def;
        }
    }

    public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    public float getFloat(String[] key) {
        return this.getFloat(key, 0.0f);
    }

    public float getFloat(String key, float def) {
        String s2 = this.config.get(key.toLowerCase());
        if (s2 == null) {
            return def;
        }
        try {
            return Float.parseFloat(s2);
        }
        catch (Exception ex) {
            return def;
        }
    }

    public float getFloat(String[] key, float def) {
        String k;
        String s2 = null;
        String[] stringArray = key;
        int n = stringArray.length;
        for (int i = 0; i < n && (s2 = this.config.get((k = stringArray[i]).toLowerCase())) == null; ++i) {
        }
        if (s2 == null) {
            return def;
        }
        try {
            return Float.parseFloat(s2);
        }
        catch (Exception ex) {
            return def;
        }
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String[] key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long def) {
        String s2 = this.config.get(key.toLowerCase());
        if (s2 == null) {
            return def;
        }
        try {
            return Long.parseLong(s2);
        }
        catch (Exception ex) {
            return def;
        }
    }

    public long getLong(String[] key, long def) {
        String k;
        String s2 = null;
        String[] stringArray = key;
        int n = stringArray.length;
        for (int i = 0; i < n && (s2 = this.config.get((k = stringArray[i]).toLowerCase())) == null; ++i) {
        }
        if (s2 == null) {
            return def;
        }
        try {
            return Long.parseLong(s2);
        }
        catch (Exception ex) {
            return def;
        }
    }

    public Color getColor(String[] key, String def) {
        String k;
        String s2 = null;
        String[] stringArray = key;
        int n = stringArray.length;
        for (int i = 0; i < n && (s2 = this.config.get((k = stringArray[i]).toLowerCase())) == null; ++i) {
        }
        return this.getColor(s2, def);
    }

    public Color getColor(String key, String def) {
        String c;
        String string = c = key == null ? def : this.getString(key, def);
        if (c == null) {
            return null;
        }
        if (c.startsWith("#") && c.length() == 7) {
            return Color.decode(c);
        }
        Log.error("Couldn't parse color '" + c + "': must be in Hex or R,G,B format");
        return Color.RED;
    }

    public List<Locus> getLocationList(String[] key, List<Locus> def) {
        String s2 = null;
        for (String k : key) {
            s2 = this.config.get(k.toLowerCase());
            if (s2 == null) continue;
            return this.getLocationList(k, def);
        }
        return def;
    }

    public List<Locus> getLocationList(String key, List<Locus> def) {
        ArrayList<Locus> result = new ArrayList<Locus>();
        String internalName = this.getString(key);
        if ((internalName = LineConfig.unparseBlock(internalName)) == null) {
            return def;
        }
        try {
            if (internalName.startsWith("[") && internalName.endsWith("]")) {
                internalName = internalName.substring(1, internalName.length() - 1);
                internalName = LineConfig.parseBlock(internalName);
                internalName = internalName.replace("- ", ";");
                String[] split = internalName.split(";");
                ArrayList elements = new ArrayList();
                for (String e : split) {
                    String[] sp = e.split(",");
                    double x = Double.valueOf(sp[0]);
                    double y = Double.valueOf(sp[1]);
                    double z = Double.valueOf(sp[2]);
                    result.add(Locus.of(x, y, z));
                }
            } else {
                String[] sp = internalName.split(",");
                double x = Double.valueOf(sp[0]);
                double y = Double.valueOf(sp[1]);
                double z = Double.valueOf(sp[2]);
                result.add(Locus.of(x, y, z));
            }
        }
        catch (Error | Exception ex) {
            Log.error("LocationList is improperly configured");
            ex.printStackTrace();
        }
        return result;
    }

    public static String unparseBlock(String s2) {
        String ns;
        int i;
        String[] split;
        if (s2.contains("\"")) {
            split = s2.split("\"");
            i = 0;
            ns = "";
            for (String ss : split) {
                ns = i % 2 == 1 ? ns.concat("\"" + LineConfig.unparseSpecialChars(ss) + "\"") : ns.concat(ss);
                ++i;
            }
            s2 = ns;
        }
        if (s2.contains("'")) {
            split = s2.split("'");
            i = 0;
            ns = "";
            for (String ss : split) {
                ns = i % 2 == 1 ? ns.concat("'" + LineConfig.unparseSpecialChars(ss) + "'") : ns.concat(ss);
                ++i;
            }
            s2 = ns;
        }
        int pos = 0;
        int count = 0;
        int ss = 0;
        int sc = 0;
        int ec = 0;
        String parsed = "";
        for (char c : s2.toCharArray()) {
            if (c == '{') {
                if (count == 0) {
                    sc = pos;
                }
                ++count;
            }
            if (c == '}' && --count == 0) {
                ec = pos;
                String f = s2.substring(ss, sc);
                String m3 = s2.substring(sc, ec).replace(" ", "<&csp>").replace("-", "<&da>");
                String e = s2.substring(ec);
                parsed = parsed + f + m3;
                ss = pos;
            }
            ++pos;
        }
        parsed = parsed + s2.substring(ss, pos);
        return parsed;
    }

    public static String parseBlock(String s2) {
        return s2.replace("<&csp>", " ").replace("<&da>", "-").trim();
    }

    public static String parseSpecialChars(String s2) {
        if (s2 == null) {
            return null;
        }
        s2 = s2.replace("<&co>", ":");
        s2 = s2.replace("<&sq>", "'");
        s2 = s2.replace("<&da>", "-");
        s2 = s2.replace("<&bs>", "\\");
        s2 = s2.replace("<&fs>", "/");
        s2 = s2.replace("<&sp>", " ");
        s2 = s2.replace("<&cm>", ",");
        s2 = s2.replace("<&sc>", ";");
        s2 = s2.replace("<&eq>", "=");
        s2 = s2.replace("<&dq>", "\"");
        s2 = s2.replace("<&rb>", "]");
        s2 = s2.replace("<&lb>", "[");
        s2 = s2.replace("<&rc>", "}");
        s2 = s2.replace("<&lc>", "{");
        s2 = s2.replace("<&nl>", "\n");
        s2 = s2.replace("<&nm>", "#");
        s2 = s2.replace("<&skull>", "\u2620");
        s2 = s2.replace("<&heart>", "\u2764");
        s2 = ChatColor.translateAlternateColorCodes((char)'&', (String)s2);
        return s2;
    }

    public static String unparseSpecialChars(String s2) {
        if (s2 == null) {
            return null;
        }
        s2 = s2.replace("-", "<&da>");
        s2 = s2.replace("\\", "<&bs>");
        s2 = s2.replace("/", "<&fs>");
        s2 = s2.replace(" ", "<&sp>");
        s2 = s2.replace(",", "<&cm>");
        s2 = s2.replace(";", "<&sc>");
        s2 = s2.replace("=", "<&eq>");
        s2 = s2.replace("{", "<&lc>");
        s2 = s2.replace("}", "<&rc>");
        s2 = s2.replace("[", "<&lb>");
        s2 = s2.replace("]", "<&rb>");
        s2 = s2.replace("'", "<&sq>");
        return s2;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getKey() {
        return this.key;
    }
}

