/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.config.file;

import io.lumine.xikage.mythicmobs.utils.config.ConfigurationSection;
import java.util.LinkedHashMap;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.representer.SafeRepresenter;

public class YamlRepresenter
extends Representer {
    public YamlRepresenter() {
        this.multiRepresenters.put(ConfigurationSection.class, new RepresentConfigurationSection());
        this.multiRepresenters.put(ConfigurationSerializable.class, new RepresentConfigurationSerializable());
    }

    private class RepresentConfigurationSerializable
    extends SafeRepresenter.RepresentMap {
        private RepresentConfigurationSerializable() {
            super((SafeRepresenter)YamlRepresenter.this);
        }

        public Node representData(Object data) {
            ConfigurationSerializable serializable = (ConfigurationSerializable)data;
            LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
            String className = serializable.getClass().getName();
            if (className.endsWith("CraftItemStack")) {
                className = "org.bukkit.inventory.ItemStack";
            }
            if (className.endsWith("CraftMetaItem")) {
                className = "ItemMeta";
            }
            if (className.contains("inventory.CraftMeta")) {
                className = "ItemMeta";
            }
            values.put("==", className);
            values.putAll(serializable.serialize());
            return super.representData(values);
        }
    }

    private class RepresentConfigurationSection
    extends SafeRepresenter.RepresentMap {
        private RepresentConfigurationSection() {
            super((SafeRepresenter)YamlRepresenter.this);
        }

        public Node representData(Object data) {
            return super.representData(((ConfigurationSection)data).getValues(false));
        }
    }
}

