/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.config.properties;

import io.lumine.xikage.mythicmobs.utils.config.ConfigurationSection;
import io.lumine.xikage.mythicmobs.utils.config.file.FileConfiguration;
import io.lumine.xikage.mythicmobs.utils.config.properties.PropertyHolder;
import io.lumine.xikage.mythicmobs.utils.logging.Log;
import io.lumine.xikage.mythicmobs.utils.plugin.LuminePlugin;
import java.util.HashMap;
import java.util.Map;

public abstract class PropertyType<T> {
    protected final LuminePlugin plugin;
    protected ConfigurationSection config;
    protected final Map<String, ConfigurationSection> holderSections = new HashMap<String, ConfigurationSection>();
    protected final String file;
    protected final String node;

    public PropertyType(LuminePlugin plugin, Object scope, String node) {
        plugin.registerProperty(this);
        this.plugin = plugin;
        this.file = scope instanceof String ? (String)scope : scope.toString();
        this.node = node;
        this.load();
    }

    public void reload() {
        this.load();
    }

    private void load() {
        this.config = this.plugin.getPropertyConfig(this.file);
        this.holderSections.clear();
    }

    public T get() {
        return this.compute(this.config, this.node);
    }

    public T get(PropertyHolder holder) {
        return this.get(holder.getPropertyNode());
    }

    public T get(String holder) {
        this.holderSections.computeIfAbsent(holder, _holder -> this.config.getConfigurationSection(holder));
        return this.compute(this.holderSections.get(holder), this.node);
    }

    public T get(ConfigurationSection section) {
        return this.compute(section, this.node);
    }

    protected abstract T compute(ConfigurationSection var1, String var2);

    public void set(PropertyHolder holder, T value) {
        this.set(holder.getPropertyNode(), value);
    }

    public void set(T value) {
        this.set((String)null, value);
    }

    public void set(String holder, T value) {
        if (this.config == null) {
            Log.info("HOLDER NULL");
            return;
        }
        if (holder != null) {
            this.config.set(holder + "." + this.node, value);
        } else {
            this.config.set(this.node, value);
        }
        try {
            Log.info("Setting file " + this.config + " TO FILE " + this.file);
            ((FileConfiguration)this.config).save(this.plugin.getPropertyFile(this.file));
        }
        catch (Error | Exception ex) {
            ex.printStackTrace();
        }
    }

    public LuminePlugin getPlugin() {
        return this.plugin;
    }

    public ConfigurationSection getConfig() {
        return this.config;
    }

    public String getFile() {
        return this.file;
    }

    public String getNode() {
        return this.node;
    }
}

