/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.config.properties.types;

import io.lumine.xikage.mythicmobs.utils.config.ConfigurationSection;
import io.lumine.xikage.mythicmobs.utils.config.properties.PropertyHolder;
import io.lumine.xikage.mythicmobs.utils.config.properties.types.StringProp;
import io.lumine.xikage.mythicmobs.utils.plugin.LuminePlugin;
import io.lumine.xikage.mythicmobs.utils.text.Text;
import java.util.Map;

public class LangProp
extends StringProp {
    public LangProp(LuminePlugin plugin, Object file, String node) {
        super(plugin, file, node);
    }

    public LangProp(LuminePlugin plugin, Object file, String node, String def) {
        super(plugin, file, node, def);
    }

    public String get(Map<String, Object> replacements) {
        return LangProp.replaceTokens((String)super.get(), replacements);
    }

    public String get(PropertyHolder holder, Map<String, Object> replacements) {
        return this.get(holder.getPropertyNode(), replacements);
    }

    public String get(String holder, Map<String, Object> replacements) {
        return LangProp.replaceTokens((String)super.get(holder), replacements);
    }

    @Override
    protected String compute(ConfigurationSection section, String node) {
        return Text.colorizeLegacy(Text.colorize(super.compute(section, node)));
    }

    protected static String replaceTokens(String src, Map<String, Object> replacements) {
        if (src.indexOf(60) == -1 || src.indexOf(62) == -1) {
            return src;
        }
        StringBuilder builder = new StringBuilder(src);
        int openIx = -1;
        for (int i = 0; i < builder.length(); ++i) {
            if (openIx == -1) {
                if (builder.charAt(i) != '{') continue;
                openIx = i;
                continue;
            }
            if (builder.charAt(i) != '}') continue;
            int closeIx = i;
            String label = builder.substring(openIx + 1, closeIx);
            Object object = replacements.get(label);
            if (object != null) {
                String replacement = replacements.get(label).toString();
                builder.replace(openIx, closeIx + 1, replacement);
                int lengthDiff = replacement.length() - (closeIx + 1 - openIx);
                i += lengthDiff;
            }
            openIx = -1;
        }
        return builder.toString();
    }
}

