/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.config.properties.types;

import io.lumine.xikage.mythicmobs.utils.collections.WeightedCollection;
import io.lumine.xikage.mythicmobs.utils.collections.WeightedEntry;
import io.lumine.xikage.mythicmobs.utils.config.ConfigurationSection;
import io.lumine.xikage.mythicmobs.utils.config.LineConfig;
import io.lumine.xikage.mythicmobs.utils.config.properties.PropertyType;
import io.lumine.xikage.mythicmobs.utils.config.properties.types.StringListProp;
import io.lumine.xikage.mythicmobs.utils.items.ItemFactory;
import io.lumine.xikage.mythicmobs.utils.logging.Log;
import io.lumine.xikage.mythicmobs.utils.plugin.LuminePlugin;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class WeightedLineItemListProp
extends PropertyType<WeightedCollection<WeightedEntry<ItemStack>>> {
    private WeightedCollection<WeightedEntry<ItemStack>> def = new WeightedCollection();
    private StringListProp LIST;

    public WeightedLineItemListProp(LuminePlugin plugin, Object file, String node) {
        super(plugin, file, node);
        this.LIST = new StringListProp(plugin, file, node);
        WeightedEntry<ItemStack> defa = new WeightedEntry<ItemStack>(new ItemStack(Material.STONE), 1.0);
        this.def.add(defa);
    }

    public WeightedLineItemListProp(LuminePlugin plugin, Object file, String node, WeightedCollection<WeightedEntry<ItemStack>> def) {
        super(plugin, file, node);
        this.LIST = new StringListProp(plugin, file, node);
        this.def = def;
    }

    @Override
    protected WeightedCollection<WeightedEntry<ItemStack>> compute(ConfigurationSection section, String node) {
        if (section == null) {
            return this.def;
        }
        WeightedCollection<WeightedEntry<ItemStack>> items = new WeightedCollection<WeightedEntry<ItemStack>>();
        for (String line : (List)this.LIST.get(section)) {
            double weight;
            LineConfig lc;
            block5: {
                lc = LineConfig.of(line);
                String[] lineSplit = lc.getLine().split(" ");
                if (lineSplit.length > 1) {
                    try {
                        weight = Double.parseDouble(lineSplit[1]);
                        break block5;
                    }
                    catch (Error | Exception ex) {
                        Log.info("Invalid entry weight {0} on line {1}", lineSplit[1], line);
                        continue;
                    }
                }
                weight = 1.0;
            }
            ItemStack item = ItemFactory.of(lc).build();
            items.add(new WeightedEntry<ItemStack>(item, weight));
        }
        return items;
    }

    @Override
    public void set(String holder, WeightedCollection<WeightedEntry<ItemStack>> value) {
        if (this.config == null) {
            return;
        }
    }
}

