/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.eventbus;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.SetMultimap;
import io.lumine.xikage.mythicmobs.utils.eventbus.Cancellable;
import io.lumine.xikage.mythicmobs.utils.eventbus.EventBus;
import io.lumine.xikage.mythicmobs.utils.eventbus.EventSubscriber;
import io.lumine.xikage.mythicmobs.utils.eventbus.PostResult;
import io.lumine.xikage.mythicmobs.utils.eventbus.ReifiedEvent;
import io.lumine.xikage.mythicmobs.utils.eventbus.SubscriberRegistry;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SimpleEventBus<E>
implements EventBus<E> {
    private final Class<E> type;
    private final SubscriberRegistry<E> registry = new SubscriberRegistry();

    public SimpleEventBus(@NonNull Class<E> type) {
        this.type = Objects.requireNonNull(type, "type");
    }

    @Override
    public @NonNull Class<E> eventType() {
        return this.type;
    }

    protected boolean eventCancelled(@NonNull E event) {
        return event instanceof Cancellable && ((Cancellable)event).cancelled();
    }

    protected @Nullable Type eventGenericType(@NonNull E event) {
        return event instanceof ReifiedEvent ? ((ReifiedEvent)event).type().getType() : null;
    }

    protected boolean shouldPost(@NonNull E event, @NonNull EventSubscriber<?> subscriber) {
        if (!subscriber.consumeCancelledEvents() && this.eventCancelled(event)) {
            return false;
        }
        return Objects.equals(this.eventGenericType(event), subscriber.genericType());
    }

    @Override
    public @NonNull PostResult post(@NonNull E event) {
        ImmutableMap.Builder<EventSubscriber<?>, Throwable> exceptions = null;
        for (EventSubscriber<?> subscriber : this.registry.subscribers(event.getClass())) {
            if (!this.shouldPost(event, subscriber)) continue;
            try {
                subscriber.invoke(event);
            }
            catch (Throwable e) {
                if (exceptions == null) {
                    exceptions = ImmutableMap.builder();
                }
                exceptions.put(subscriber, e);
            }
        }
        if (exceptions == null) {
            return PostResult.success();
        }
        return PostResult.failure(exceptions.build());
    }

    @Override
    public <T extends E> void register(@NonNull Class<T> clazz, @NonNull EventSubscriber<? super T> subscriber) {
        this.eventClassCheck(clazz);
        this.registry.register(clazz, subscriber);
    }

    @Override
    public void unregister(@NonNull EventSubscriber<?> subscriber) {
        this.registry.unregister(subscriber);
    }

    @Override
    public void unregister(@NonNull Predicate<EventSubscriber<?>> predicate) {
        this.registry.unregisterMatching(predicate);
    }

    @Override
    public void unregisterAll() {
        this.registry.unregisterAll();
    }

    @Override
    public <T extends E> boolean hasSubscribers(@NonNull Class<T> clazz) {
        this.eventClassCheck(clazz);
        return !this.registry.subscribers(clazz).isEmpty();
    }

    @Override
    public @NonNull SetMultimap<Class<?>, EventSubscriber<?>> subscribers() {
        return this.registry.subscribers();
    }

    private <T extends E> void eventClassCheck(@NonNull Class<T> clazz) {
        if (!this.type.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("class " + clazz + " cannot be casted to event type " + this.type);
        }
    }
}

