/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.events.functional.single;

import io.lumine.xikage.mythicmobs.utils.events.SingleSubscription;
import io.lumine.xikage.mythicmobs.utils.events.functional.single.SingleSubscriptionBuilderImpl;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;

class EventListener<T extends Event>
implements SingleSubscription<T>,
EventExecutor,
Listener {
    private final Class<T> eventClass;
    private final EventPriority priority;
    private final BiConsumer<? super T, Throwable> exceptionConsumer;
    private final boolean handleSubclasses;
    private final Predicate<T>[] filters;
    private final BiPredicate<SingleSubscription<T>, T>[] preExpiryTests;
    private final BiPredicate<SingleSubscription<T>, T>[] midExpiryTests;
    private final BiPredicate<SingleSubscription<T>, T>[] postExpiryTests;
    private final BiConsumer<SingleSubscription<T>, ? super T>[] handlers;
    private final AtomicLong callCount = new AtomicLong(0L);
    private final AtomicBoolean active = new AtomicBoolean(true);

    EventListener(SingleSubscriptionBuilderImpl<T> builder, List<BiConsumer<SingleSubscription<T>, ? super T>> handlers) {
        this.eventClass = builder.eventClass;
        this.priority = builder.priority;
        this.exceptionConsumer = builder.exceptionConsumer;
        this.handleSubclasses = builder.handleSubclasses;
        this.filters = builder.filters.toArray(new Predicate[builder.filters.size()]);
        this.preExpiryTests = builder.preExpiryTests.toArray(new BiPredicate[builder.preExpiryTests.size()]);
        this.midExpiryTests = builder.midExpiryTests.toArray(new BiPredicate[builder.midExpiryTests.size()]);
        this.postExpiryTests = builder.postExpiryTests.toArray(new BiPredicate[builder.postExpiryTests.size()]);
        this.handlers = handlers.toArray(new BiConsumer[handlers.size()]);
    }

    void register(Plugin plugin) {
        Bukkit.getPluginManager().registerEvent(this.eventClass, (Listener)this, this.priority, (EventExecutor)this, plugin, false);
    }

    public void execute(Listener listener, Event event) {
        if (this.handleSubclasses ? !this.eventClass.isInstance(event) : event.getClass() != this.eventClass) {
            return;
        }
        if (!this.active.get()) {
            event.getHandlers().unregister(listener);
            return;
        }
        Event eventInstance = (Event)this.eventClass.cast(event);
        for (BiPredicate<SingleSubscription<EventListener>, EventListener> biPredicate : this.preExpiryTests) {
            if (!biPredicate.test(this, (EventListener)eventInstance)) continue;
            event.getHandlers().unregister(listener);
            this.active.set(false);
            return;
        }
        try {
            for (Predicate<T> predicate : this.filters) {
                if (predicate.test(eventInstance)) continue;
                return;
            }
            for (BiPredicate<SingleSubscription<T>, T> biPredicate : this.midExpiryTests) {
                if (!biPredicate.test(this, eventInstance)) continue;
                event.getHandlers().unregister(listener);
                this.active.set(false);
                return;
            }
            for (BiConsumer<SingleSubscription<T>, ? super T> biConsumer : this.handlers) {
                biConsumer.accept(this, (T)eventInstance);
            }
            this.callCount.incrementAndGet();
        }
        catch (Throwable t) {
            this.exceptionConsumer.accept(eventInstance, t);
        }
        for (BiPredicate<SingleSubscription<T>, T> biPredicate : this.postExpiryTests) {
            if (!biPredicate.test(this, eventInstance)) continue;
            event.getHandlers().unregister(listener);
            this.active.set(false);
            return;
        }
    }

    @Override
    @Nonnull
    public Class<T> getEventClass() {
        return this.eventClass;
    }

    @Override
    public boolean isActive() {
        return this.active.get();
    }

    @Override
    public boolean isClosed() {
        return !this.active.get();
    }

    @Override
    public long getCallCounter() {
        return this.callCount.get();
    }

    @Override
    public boolean unregister() {
        if (!this.active.getAndSet(false)) {
            return false;
        }
        EventListener.unregisterListener(this.eventClass, this);
        return true;
    }

    private static void unregisterListener(Class<? extends Event> eventClass, Listener listener) {
        try {
            Method getHandlerListMethod = eventClass.getMethod("getHandlerList", new Class[0]);
            HandlerList handlerList = (HandlerList)getHandlerListMethod.invoke(null, new Object[0]);
            handlerList.unregister(listener);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

