/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.numbers;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Numbers {
    private static Random random = new Random();

    @Nullable
    public static Number parseNullable(@Nonnull String s2) {
        Objects.requireNonNull(s2);
        try {
            return NumberFormat.getInstance().parse(s2);
        }
        catch (ParseException e) {
            return null;
        }
    }

    @Nonnull
    public static Optional<Number> parse(@Nonnull String s2) {
        return Optional.ofNullable(Numbers.parseNullable(s2));
    }

    @Nullable
    public static Integer parseIntegerNullable(@Nonnull String s2) {
        Objects.requireNonNull(s2);
        try {
            return Integer.parseInt(s2);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nonnull
    public static Optional<Integer> parseIntegerOpt(@Nonnull String s2) {
        return Optional.ofNullable(Numbers.parseIntegerNullable(s2));
    }

    @Nonnull
    public static OptionalInt parseInteger(@Nonnull String s2) {
        try {
            return OptionalInt.of(Integer.parseInt(s2));
        }
        catch (NumberFormatException e) {
            return OptionalInt.empty();
        }
    }

    @Nullable
    public static Long parseLongNullable(@Nonnull String s2) {
        Objects.requireNonNull(s2);
        try {
            return Long.parseLong(s2);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nonnull
    public static Optional<Long> parseLongOpt(@Nonnull String s2) {
        return Optional.ofNullable(Numbers.parseLongNullable(s2));
    }

    @Nonnull
    public static OptionalLong parseLong(@Nonnull String s2) {
        try {
            return OptionalLong.of(Long.parseLong(s2));
        }
        catch (NumberFormatException e) {
            return OptionalLong.empty();
        }
    }

    @Nullable
    public static Float parseFloatNullable(@Nonnull String s2) {
        Objects.requireNonNull(s2);
        try {
            return Float.valueOf(Float.parseFloat(s2));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nonnull
    public static Optional<Float> parseFloatOpt(@Nonnull String s2) {
        return Optional.ofNullable(Numbers.parseFloatNullable(s2));
    }

    @Nonnull
    public static OptionalDouble parseFloat(@Nonnull String s2) {
        try {
            return OptionalDouble.of(Float.parseFloat(s2));
        }
        catch (NumberFormatException e) {
            return OptionalDouble.empty();
        }
    }

    @Nullable
    public static Double parseDoubleNullable(@Nonnull String s2) {
        Objects.requireNonNull(s2);
        try {
            return Double.parseDouble(s2);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nonnull
    public static Optional<Double> parseDoubleOpt(@Nonnull String s2) {
        return Optional.ofNullable(Numbers.parseDoubleNullable(s2));
    }

    @Nonnull
    public static OptionalDouble parseDouble(@Nonnull String s2) {
        try {
            return OptionalDouble.of(Double.parseDouble(s2));
        }
        catch (NumberFormatException e) {
            return OptionalDouble.empty();
        }
    }

    @Nullable
    public static Byte parseByteNullable(@Nonnull String s2) {
        Objects.requireNonNull(s2);
        try {
            return Byte.parseByte(s2);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nonnull
    public static Optional<Byte> parseByteOpt(@Nonnull String s2) {
        return Optional.ofNullable(Numbers.parseByteNullable(s2));
    }

    public static int randomInt() {
        return random.nextInt();
    }

    public static int randomInt(int bound) {
        return random.nextInt(bound);
    }

    public static double randomDouble() {
        return random.nextDouble();
    }

    public static long randomLong() {
        return random.nextLong();
    }

    public static boolean randomBoolean() {
        return random.nextBoolean();
    }

    public static int floor(double num) {
        int floor = (int)num;
        return (double)floor == num ? floor : floor - (int)(Double.doubleToRawLongBits(num) >>> 63);
    }

    public static int ceil(double num) {
        int floor = (int)num;
        return (double)floor == num ? floor : floor + (int)((Double.doubleToRawLongBits(num) ^ 0xFFFFFFFFFFFFFFFFL) >>> 63);
    }

    public static int round(double num) {
        return Numbers.floor(num + 0.5);
    }

    public static double square(double num) {
        return num * num;
    }

    public static int toInt(Object object) {
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        try {
            return Integer.valueOf(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return 0;
    }

    public static float toFloat(Object object) {
        if (object instanceof Number) {
            return ((Number)object).floatValue();
        }
        try {
            return Float.valueOf(object.toString()).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return 0.0f;
    }

    public static double toDouble(Object object) {
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        try {
            return Double.valueOf(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return 0.0;
    }

    public static long toLong(Object object) {
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        try {
            return Long.valueOf(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return 0L;
    }

    public static short toShort(Object object) {
        if (object instanceof Number) {
            return ((Number)object).shortValue();
        }
        try {
            return Short.valueOf(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return 0;
    }

    public static byte toByte(Object object) {
        if (object instanceof Number) {
            return ((Number)object).byteValue();
        }
        try {
            return Byte.valueOf(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return 0;
    }

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = new BigDecimal(Double.toString(value));
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public static String addCommas(int number) {
        NumberFormat format = NumberFormat.getInstance();
        format.setGroupingUsed(true);
        return format.format(number);
    }

    private Numbers() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }
}

