/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.plugin;

import com.google.common.base.Preconditions;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import io.lumine.xikage.mythicmobs.utils.config.ConfigurationLoader;
import io.lumine.xikage.mythicmobs.utils.config.ConfigurationSection;
import io.lumine.xikage.mythicmobs.utils.config.properties.PropertyType;
import io.lumine.xikage.mythicmobs.utils.terminable.Terminable;
import io.lumine.xikage.mythicmobs.utils.terminable.TerminableConsumer;
import io.lumine.xikage.mythicmobs.utils.terminable.TerminableModule;
import io.lumine.xikage.mythicmobs.utils.terminable.composite.CompositeTerminable;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class LuminePlugin
extends JavaPlugin
implements Terminable,
TerminableConsumer {
    private CompositeTerminable terminableRegistry = CompositeTerminable.create();
    private Map<String, ConfigurationLoader<LuminePlugin>> propertyFiles = new ConcurrentHashMap<String, ConfigurationLoader<LuminePlugin>>();
    private Set<PropertyType> properties = new HashSet<PropertyType>();

    protected void load() {
    }

    protected void enable() {
    }

    protected void disable() {
    }

    public final void onLoad() {
        this.terminableRegistry = CompositeTerminable.create();
        this.load();
    }

    public final void onEnable() {
        Schedulers.builder().async().after(10L, TimeUnit.SECONDS).every(30L, TimeUnit.SECONDS).run(this.terminableRegistry::cleanup).bindWith(this.terminableRegistry);
        this.enable();
    }

    public final void onDisable() {
        try {
            this.disable();
        }
        catch (Error | Exception ex) {
            ex.printStackTrace();
        }
        this.close();
    }

    @Override
    public void close() {
        this.terminableRegistry.closeAndReportException();
    }

    public void reloadConfiguration() {
        this.propertyFiles.clear();
        this.properties.forEach(prop -> prop.reload());
    }

    @Override
    @Nonnull
    public <T extends AutoCloseable> T bind(@Nonnull T terminable) {
        return this.terminableRegistry.bind(terminable);
    }

    @Override
    @Nonnull
    public <T extends TerminableModule> T bindModule(@Nonnull T module) {
        return this.terminableRegistry.bindModule(module);
    }

    @Nonnull
    public <T extends CommandExecutor & TabCompleter> void registerCommand(String cmd, T handler) {
        this.getCommand(cmd).setExecutor(handler);
        this.getCommand(cmd).setTabCompleter((TabCompleter)handler);
    }

    @Nonnull
    public <T extends Listener> void registerListener(@Nonnull T listener) {
        Preconditions.checkNotNull(listener, "listener");
        this.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
    }

    @Nullable
    public <T> T getService(@Nonnull Class<T> service) {
        return (T)this.getServer().getServicesManager().load(service);
    }

    @Nonnull
    public <T> T provideService(@Nonnull Class<T> clazz, @Nonnull T instance, @Nonnull ServicePriority priority) {
        this.getServer().getServicesManager().register(clazz, instance, (Plugin)this, priority);
        return instance;
    }

    @Nonnull
    public <T> T provideService(@Nonnull Class<T> clazz, @Nonnull T instance) {
        Preconditions.checkNotNull(clazz, "clazz");
        Preconditions.checkNotNull(instance, "instance");
        return this.provideService(clazz, instance, ServicePriority.Normal);
    }

    @Nullable
    public <T> T getPlugin(@Nonnull String name, @Nonnull Class<T> pluginClass) {
        Preconditions.checkNotNull(name, "name");
        Preconditions.checkNotNull(pluginClass, "pluginClass");
        return (T)this.getServer().getPluginManager().getPlugin(name);
    }

    public boolean isPluginPresent(@Nonnull String name) {
        return this.getServer().getPluginManager().getPlugin(name) != null;
    }

    public void registerProperty(PropertyType property) {
        this.properties.add(property);
    }

    public ConfigurationSection getPropertyConfig(String file) {
        ConfigurationLoader<LuminePlugin> loader;
        if (this.propertyFiles.containsKey(file)) {
            loader = this.propertyFiles.get(file);
        } else {
            loader = new ConfigurationLoader<LuminePlugin>(this, file + ".yml");
            this.propertyFiles.put(file, loader);
        }
        return loader.getCustomConfig();
    }

    public File getPropertyFile(String file) {
        ConfigurationLoader<LuminePlugin> loader;
        if (this.propertyFiles.containsKey(file)) {
            loader = this.propertyFiles.get(file);
        } else {
            loader = new ConfigurationLoader<LuminePlugin>(this, file + ".yml");
            this.propertyFiles.put(file, loader);
        }
        return loader.getFile();
    }
}

