/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.serialize;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.lumine.xikage.mythicmobs.utils.cache.Lazy;
import io.lumine.xikage.mythicmobs.utils.gson.GsonSerializable;
import io.lumine.xikage.mythicmobs.utils.gson.JsonBuilder;
import io.lumine.xikage.mythicmobs.utils.serialize.BlockLocus;
import io.lumine.xikage.mythicmobs.utils.serialize.BlockPosition;
import io.lumine.xikage.mythicmobs.utils.serialize.ChunkPosition;
import io.lumine.xikage.mythicmobs.utils.serialize.Locus;
import io.lumine.xikage.mythicmobs.utils.serialize.Position;
import io.lumine.xikage.mythicmobs.utils.serialize.Region;
import io.lumine.xikage.mythicmobs.utils.serialize.Zone;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.block.BlockFace;

public final class ChunkLocus
implements GsonSerializable {
    private final int x;
    private final int z;
    private final Lazy<Collection<BlockLocus>> blocks = Lazy.suppliedBy(() -> {
        ArrayList<BlockLocus> blocks = new ArrayList<BlockLocus>(65536);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 256; ++y) {
                    blocks.add(this.getBlock(x, y, z));
                }
            }
        }
        return Collections.unmodifiableList(blocks);
    });

    public static ChunkLocus deserialize(JsonElement element) {
        Preconditions.checkArgument(element.isJsonObject());
        JsonObject object = element.getAsJsonObject();
        Preconditions.checkArgument(object.has("x"));
        Preconditions.checkArgument(object.has("z"));
        int x = object.get("x").getAsInt();
        int z = object.get("z").getAsInt();
        return ChunkLocus.of(x, z);
    }

    public static ChunkLocus of(int x, int z) {
        return new ChunkLocus(x, z);
    }

    public static ChunkLocus of(Chunk location) {
        Objects.requireNonNull(location, "location");
        return ChunkLocus.of(location.getX(), location.getZ());
    }

    public static Collection<ChunkLocus> of(Region region) {
        return ChunkLocus.of(region.toZone());
    }

    public static Collection<ChunkLocus> of(Zone zone) {
        HashSet<ChunkLocus> ret = new HashSet<ChunkLocus>();
        int x = (int)zone.getMin().getX();
        while ((double)x <= zone.getMax().getX()) {
            int z = (int)zone.getMin().getZ();
            while ((double)z <= zone.getMax().getZ()) {
                ChunkLocus locus = ChunkLocus.of(x >> 4, z >> 4);
                if (!ret.contains(locus)) {
                    ret.add(locus);
                }
                ++z;
            }
            ++x;
        }
        return ret;
    }

    private ChunkLocus(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public Chunk toChunk(String world) {
        return Bukkit.getWorld((String)world).getChunkAt(this.x, this.z);
    }

    public Chunk toChunk(World world) {
        return world.getChunkAt(this.x, this.z);
    }

    public boolean contains(BlockPosition block) {
        return this.equals(block.toChunk());
    }

    public boolean contains(Position position) {
        return this.equals(position.floor().toChunk());
    }

    public boolean contains(Locus position) {
        return this.equals(position.floor().toChunkLocus());
    }

    public BlockLocus getBlock(int x, int y, int z) {
        return BlockLocus.of(this.x << 4 | x & 0xF, y, this.z << 4 | z & 0xF);
    }

    public Locus getLocus(int x, int y, int z) {
        return Locus.of(this.x << 4 | x & 0xF, y, this.z << 4 | z & 0xF);
    }

    public Collection<BlockLocus> blocks() {
        return this.blocks.get();
    }

    public ChunkLocus getRelative(BlockFace face) {
        Preconditions.checkArgument(face != BlockFace.UP && face != BlockFace.DOWN, "invalid face");
        return ChunkLocus.of(this.x + face.getModX(), this.z + face.getModZ());
    }

    public ChunkLocus getRelative(BlockFace face, int distance) {
        Preconditions.checkArgument(face != BlockFace.UP && face != BlockFace.DOWN, "invalid face");
        return ChunkLocus.of(this.x + face.getModX() * distance, this.z + face.getModZ() * distance);
    }

    public ChunkLocus add(int x, int z) {
        return ChunkLocus.of(this.x + x, this.z + z);
    }

    public ChunkLocus subtract(int x, int z) {
        return this.add(-x, -z);
    }

    @Override
    @Nonnull
    public JsonObject serialize() {
        return JsonBuilder.object().add("x", this.x).add("z", this.z).build();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ChunkPosition) {
            ChunkPosition other = (ChunkPosition)o;
            return this.getX() == other.getX() && this.getZ() == other.getZ();
        }
        if (o instanceof ChunkLocus) {
            ChunkLocus other = (ChunkLocus)o;
            return this.getX() == other.getX() && this.getZ() == other.getZ();
        }
        return false;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getX();
        result = result * 59 + this.getZ();
        return result;
    }

    public String toString() {
        return "ChunkLocus(x=" + this.getX() + ", z=" + this.getZ() + ")";
    }
}

