/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.serialize;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import io.lumine.xikage.mythicmobs.utils.gson.GsonProvider;
import io.lumine.xikage.mythicmobs.utils.serialize.FileStorageHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class GsonStorageHandler<T>
extends FileStorageHandler<T> {
    protected final Type type;
    protected final Gson gson;

    public GsonStorageHandler(String fileName, String fileExtension, File dataFolder, Class<T> clazz) {
        this(fileName, fileExtension, dataFolder, TypeToken.of(clazz));
    }

    public GsonStorageHandler(String fileName, String fileExtension, File dataFolder, Class<T> clazz, Gson gson) {
        this(fileName, fileExtension, dataFolder, TypeToken.of(clazz), gson);
    }

    public GsonStorageHandler(String fileName, String fileExtension, File dataFolder, TypeToken<T> type) {
        this(fileName, fileExtension, dataFolder, type.getType());
    }

    public GsonStorageHandler(String fileName, String fileExtension, File dataFolder, TypeToken<T> type, Gson gson) {
        this(fileName, fileExtension, dataFolder, type.getType(), gson);
    }

    public GsonStorageHandler(String fileName, String fileExtension, File dataFolder, Type type) {
        this(fileName, fileExtension, dataFolder, type, GsonProvider.prettyPrinting());
    }

    public GsonStorageHandler(String fileName, String fileExtension, File dataFolder, Type type, Gson gson) {
        super(fileName, fileExtension, dataFolder);
        this.type = type;
        this.gson = gson;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected T readFromFile(Path path) {
        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            Object t = this.gson.fromJson((Reader)reader, this.type);
            return t;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected void saveToFile(Path path, T t) {
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            this.gson.toJson(t, this.type, writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

