/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.storage.players;

import com.google.common.collect.Maps;
import io.lumine.xikage.mythicmobs.utils.Events;
import io.lumine.xikage.mythicmobs.utils.plugin.LuminePlugin;
import io.lumine.xikage.mythicmobs.utils.promise.Promise;
import io.lumine.xikage.mythicmobs.utils.storage.StorageModule;
import io.lumine.xikage.mythicmobs.utils.storage.events.LumineProfileLoadEvent;
import io.lumine.xikage.mythicmobs.utils.storage.players.PlayerStorageAdapter;
import io.lumine.xikage.mythicmobs.utils.storage.players.Profile;
import io.lumine.xikage.mythicmobs.utils.storage.players.ProfileRepository;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public abstract class PlayerRepository<T extends LuminePlugin, P extends Profile>
extends StorageModule<T>
implements ProfileRepository<P> {
    private final Map<UUID, P> profilesById = Maps.newConcurrentMap();
    private final Map<String, P> profilesByName = Maps.newConcurrentMap();
    private final Class<P> clazz;
    private final PlayerStorageAdapter<P> adapter;

    public PlayerRepository(T plugin, Class<P> clazz, PlayerStorageAdapter<P> adapter) {
        super(plugin);
        this.clazz = clazz;
        this.adapter = adapter;
        this.load(plugin);
    }

    @Override
    public void load(T plugin) {
        Events.subscribe(PlayerJoinEvent.class).handler(event -> this.adapter.load(event.getPlayer().getUniqueId()).thenAcceptSync(maybeProfile -> {
            Player player = event.getPlayer();
            Profile profile = !maybeProfile.isPresent() ? this.createProfile(player.getUniqueId(), player.getName()) : (Profile)maybeProfile.get();
            this.profilesById.put(player.getUniqueId(), profile);
            this.profilesByName.put(player.getName(), profile);
            this.initProfile(profile, player);
            Events.call(new LumineProfileLoadEvent<Profile>(player, profile));
        })).bindWith(this);
        Events.subscribe(PlayerQuitEvent.class, EventPriority.MONITOR).handler(event -> {
            UUID uuid = event.getPlayer().getUniqueId();
            Profile profile = (Profile)this.profilesById.remove(uuid);
            this.profilesByName.remove(event.getPlayer().getName());
            if (profile != null) {
                this.unloadProfile(profile, event.getPlayer());
                this.adapter.save(uuid, profile);
            }
        }).bindWith(this);
    }

    @Override
    public void unload() {
    }

    public abstract P createProfile(UUID var1, String var2);

    public abstract void initProfile(P var1, Player var2);

    public abstract void unloadProfile(P var1, Player var2);

    @Override
    public P getProfile(Player player) {
        return (P)((Profile)this.profilesById.getOrDefault(player.getUniqueId(), null));
    }

    @Override
    public Optional<P> getProfile(UUID uniqueId) {
        return Optional.ofNullable(this.profilesById.getOrDefault(uniqueId, null));
    }

    @Override
    public Optional<P> getProfile(String name) {
        return Optional.ofNullable(this.profilesByName.getOrDefault(name, null));
    }

    @Override
    public Collection<P> getKnownProfiles() {
        return this.profilesById.values();
    }

    public Promise<Optional<P>> awaitProfile(Player player) {
        Promise promise = Promise.empty();
        UUID uuid = player.getUniqueId();
        if (this.profilesById.containsKey(uuid)) {
            promise.supply(Optional.of(this.profilesById.get(uuid)));
        } else {
            Events.subscribe(LumineProfileLoadEvent.class, EventPriority.MONITOR).expireAfter(1L).expireAfter(5L, TimeUnit.SECONDS).filter(event -> event.getPlayer().getUniqueId().equals(player.getUniqueId())).filter(event -> this.clazz.isInstance(event.getProfile())).biHandler((handler, event) -> {
                promise.supply(Optional.of(event.getProfile()));
                handler.terminate();
            });
            if (this.profilesById.containsKey(uuid)) {
                promise.supply(Optional.of(this.profilesById.get(uuid)));
            }
        }
        return promise;
    }

    @Override
    public Promise<Optional<P>> lookupProfile(UUID uniqueId) {
        return this.adapter.load(uniqueId);
    }

    @Override
    public Promise<Optional<P>> lookupProfile(String name) {
        return this.adapter.loadByName(name);
    }
}

