/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.storage.players.adapters.file;

import io.lumine.xikage.mythicmobs.utils.gson.GsonProvider;
import io.lumine.xikage.mythicmobs.utils.logging.Log;
import io.lumine.xikage.mythicmobs.utils.plugin.LuminePlugin;
import io.lumine.xikage.mythicmobs.utils.promise.Promise;
import io.lumine.xikage.mythicmobs.utils.storage.players.Profile;
import io.lumine.xikage.mythicmobs.utils.storage.players.adapters.FilePlayerStorageAdapter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Optional;
import java.util.UUID;

public class JsonPlayerStorageAdapter<T extends LuminePlugin, P extends Profile>
extends FilePlayerStorageAdapter<T, P> {
    private Class<P> clazz;

    public JsonPlayerStorageAdapter(T plugin, Class<P> clazz) {
        super(plugin);
        this.clazz = clazz;
    }

    @Override
    public void load(T plugin) {
    }

    @Override
    public void unload() {
    }

    @Override
    public Promise<Optional<P>> load(UUID key) {
        return Promise.supplyingAsync(() -> {
            File file = this.getFile(key.toString());
            if (!file.exists()) {
                return Optional.empty();
            }
            try (FileReader reader = new FileReader(file);){
                Optional<P> optional = Optional.of(GsonProvider.standard().fromJson((Reader)reader, this.clazz));
                return optional;
            }
            catch (IOException e) {
                Log.severe("Failed to load Json Profile in: " + this.getClass().getName());
                e.printStackTrace();
                return Optional.empty();
            }
        });
    }

    @Override
    public Promise<Boolean> save(UUID key, P object) {
        return Promise.supplyingAsync(() -> {
            File file = this.getFile(key.toString());
            if (!file.exists()) {
                try {
                    file.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            try (FileWriter writer = new FileWriter(file);){
                GsonProvider.standard().toJson((Object)object, (Appendable)writer);
                Boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                Log.severe("Failed to save Json Profile in: " + this.getClass().getName());
                e.printStackTrace();
                return false;
            }
        });
    }

    @Override
    protected File getFile(String key) {
        return new File(this.getStorageDirectory(), key + ".json");
    }
}

