/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.tasks;

import io.lumine.xikage.mythicmobs.utils.interfaces.Delegate;
import io.lumine.xikage.mythicmobs.utils.logging.Log;
import io.lumine.xikage.mythicmobs.utils.plugin.LoaderUtils;
import io.lumine.xikage.mythicmobs.utils.tasks.LumineAsyncExecutor;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public final class LumineExecutors {
    private static final Consumer<Throwable> EXCEPTION_CONSUMER = throwable -> {
        Log.severe("[SCHEDULER] Exception thrown whilst executing task");
        throwable.printStackTrace();
    };
    private static final Executor SYNC_BUKKIT = new BukkitSyncExecutor();
    private static final Executor ASYNC_BUKKIT = new BukkitAsyncExecutor();
    private static final LumineAsyncExecutor ASYNC_LUMINE = new LumineAsyncExecutor();

    public static Executor sync() {
        return SYNC_BUKKIT;
    }

    public static ScheduledExecutorService asyncLumine() {
        return ASYNC_LUMINE;
    }

    public static Executor asyncBukkit() {
        return ASYNC_BUKKIT;
    }

    public static void shutdown() {
        ASYNC_LUMINE.cancelRepeatingTasks();
    }

    public static Runnable wrapRunnable(Runnable runnable) {
        return new SchedulerWrappedRunnable(runnable);
    }

    private LumineExecutors() {
    }

    private static final class SchedulerWrappedRunnable
    implements Runnable,
    Delegate<Runnable> {
        private final Runnable delegate;

        private SchedulerWrappedRunnable(Runnable delegate) {
            this.delegate = delegate;
        }

        @Override
        public void run() {
            try {
                this.delegate.run();
            }
            catch (Throwable t) {
                EXCEPTION_CONSUMER.accept(t);
            }
        }

        @Override
        public Runnable getDelegate() {
            return this.delegate;
        }
    }

    private static final class BukkitAsyncExecutor
    implements Executor {
        private BukkitAsyncExecutor() {
        }

        @Override
        public void execute(Runnable runnable) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)LoaderUtils.getPlugin(), LumineExecutors.wrapRunnable(runnable));
        }
    }

    private static final class BukkitSyncExecutor
    implements Executor {
        private BukkitSyncExecutor() {
        }

        @Override
        public void execute(Runnable runnable) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LoaderUtils.getPlugin(), LumineExecutors.wrapRunnable(runnable));
        }
    }
}

