/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.terminable;

import io.lumine.xikage.mythicmobs.utils.terminable.TerminableConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@FunctionalInterface
public interface Terminable
extends AutoCloseable {
    public static final Terminable EMPTY = () -> {};

    default public boolean terminate() {
        this.closeAndReportException();
        return true;
    }

    @Override
    public void close() throws Exception;

    default public boolean isClosed() {
        return this.hasTerminated();
    }

    default public boolean hasTerminated() {
        return false;
    }

    @Nullable
    default public Exception closeSilently() {
        try {
            this.close();
            return null;
        }
        catch (Exception e) {
            return e;
        }
    }

    default public void closeAndReportException() {
        try {
            this.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    default public void bindWith(@Nonnull TerminableConsumer consumer) {
        consumer.bind(this);
    }
}

