/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.volatilecode.v1_13_R2.ai.goals;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.mobs.ai.WrappedPathfindingGoal;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicAIGoal;
import io.lumine.xikage.mythicmobs.volatilecode.v1_13_R2.ai.PathfinderHolder;
import java.util.List;
import net.minecraft.server.v1_13_R2.EntityCreature;
import net.minecraft.server.v1_13_R2.EntityInsentient;
import net.minecraft.server.v1_13_R2.PathfinderGoal;
import net.minecraft.server.v1_13_R2.PathfinderGoalAvoidTarget;
import org.bukkit.entity.Entity;

@MythicAIGoal(name="fleeConditional", aliases={"fleeIf"}, description="Run away from nearby entities that meets the conditions", premium=true)
public class FleeConditionalGoal
extends WrappedPathfindingGoal
implements PathfinderHolder {
    protected float distance;
    protected double speed;
    protected double safeSpeed;
    protected String conditionString;
    protected List<SkillCondition> conditions = null;

    public FleeConditionalGoal(AbstractEntity entity, String line, MythicLineConfig mlc) {
        super(entity, line, mlc);
        this.distance = mlc.getFloat(new String[]{"distance", "d"}, 4.0f);
        this.speed = mlc.getDouble(new String[]{"speed", "s"}, (double)1.2f);
        this.safeSpeed = mlc.getDouble(new String[]{"safespeed", "ss"}, 1.0);
        this.conditionString = mlc.getString(new String[]{"fleeconditions", "conditions", "cond", "c"}, "null", new String[0]);
        if (this.conditionString != null) {
            this.conditions = FleeConditionalGoal.getPlugin().getSkillManager().getConditions(this.conditionString);
        }
    }

    @Override
    public boolean isValid() {
        return this.entity.isCreature();
    }

    @Override
    public PathfinderGoal create() {
        EntityInsentient e = PathfinderHolder.getNMSEntity(this.entity);
        return new PathfinderGoalAvoidTarget((EntityCreature)e, EntityInsentient.class, this.distance, this.safeSpeed, this.speed, targetEntity -> {
            try {
                AbstractEntity absEntity = BukkitAdapter.adapt((Entity)((EntityInsentient)targetEntity).getBukkitEntity());
                for (SkillCondition cond : this.conditions) {
                    if (cond.evaluateToEntity(this.entity, absEntity)) continue;
                    return false;
                }
            }
            catch (Error | Exception ex) {
                ex.printStackTrace();
            }
            return true;
        });
    }
}

