/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.volatilecode.v1_16_R2;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.mobs.ai.Pathfinder;
import io.lumine.xikage.mythicmobs.mobs.ai.PathfinderAdapter;
import io.lumine.xikage.mythicmobs.mobs.ai.WrappedPathfinder;
import io.lumine.xikage.mythicmobs.util.annotations.MythicAIGoal;
import io.lumine.xikage.mythicmobs.util.reflections.VersionCompliantReflections;
import io.lumine.xikage.mythicmobs.utils.reflection.Reflector;
import io.lumine.xikage.mythicmobs.volatilecode.VolatileCodeHandler;
import io.lumine.xikage.mythicmobs.volatilecode.handlers.VolatileAIHandler;
import io.lumine.xikage.mythicmobs.volatilecode.v1_16_R2.ai.CustomAIAdapter;
import io.lumine.xikage.mythicmobs.volatilecode.v1_16_R2.ai.PathfinderHolder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.minecraft.server.v1_16_R2.EntityCreature;
import net.minecraft.server.v1_16_R2.EntityHuman;
import net.minecraft.server.v1_16_R2.EntityInsentient;
import net.minecraft.server.v1_16_R2.EntityIronGolem;
import net.minecraft.server.v1_16_R2.EntityLiving;
import net.minecraft.server.v1_16_R2.EntityMonster;
import net.minecraft.server.v1_16_R2.EntitySkeleton;
import net.minecraft.server.v1_16_R2.EntityTameableAnimal;
import net.minecraft.server.v1_16_R2.EntityVillager;
import net.minecraft.server.v1_16_R2.EntityWolf;
import net.minecraft.server.v1_16_R2.IMonster;
import net.minecraft.server.v1_16_R2.IRangedEntity;
import net.minecraft.server.v1_16_R2.PathfinderGoal;
import net.minecraft.server.v1_16_R2.PathfinderGoalArrowAttack;
import net.minecraft.server.v1_16_R2.PathfinderGoalAvoidTarget;
import net.minecraft.server.v1_16_R2.PathfinderGoalBowShoot;
import net.minecraft.server.v1_16_R2.PathfinderGoalBreakDoor;
import net.minecraft.server.v1_16_R2.PathfinderGoalDoorOpen;
import net.minecraft.server.v1_16_R2.PathfinderGoalEatTile;
import net.minecraft.server.v1_16_R2.PathfinderGoalFleeSun;
import net.minecraft.server.v1_16_R2.PathfinderGoalFloat;
import net.minecraft.server.v1_16_R2.PathfinderGoalLeapAtTarget;
import net.minecraft.server.v1_16_R2.PathfinderGoalLookAtPlayer;
import net.minecraft.server.v1_16_R2.PathfinderGoalMeleeAttack;
import net.minecraft.server.v1_16_R2.PathfinderGoalMoveThroughVillage;
import net.minecraft.server.v1_16_R2.PathfinderGoalMoveTowardsRestriction;
import net.minecraft.server.v1_16_R2.PathfinderGoalNearestAttackableTarget;
import net.minecraft.server.v1_16_R2.PathfinderGoalOwnerHurtByTarget;
import net.minecraft.server.v1_16_R2.PathfinderGoalPanic;
import net.minecraft.server.v1_16_R2.PathfinderGoalRestrictSun;
import net.minecraft.server.v1_16_R2.PathfinderGoalSelector;
import org.bukkit.craftbukkit.v1_16_R2.entity.CraftLivingEntity;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityTargetEvent;

public class VolatileAIHandler_v1_16_R2
implements VolatileAIHandler {
    private Reflector<EntityInsentient> refEntityInsentient = new Reflector<EntityInsentient>(EntityInsentient.class, "goalSelector", "targetSelector");
    private Reflector<PathfinderGoalSelector> refGoalSelector = new Reflector<PathfinderGoalSelector>(PathfinderGoalSelector.class, "c", "d");
    private final Map<String, Class<? extends PathfinderAdapter>> AI_GOALS = new ConcurrentHashMap<String, Class<? extends PathfinderAdapter>>();
    private final Map<String, Class<? extends PathfinderAdapter>> AI_TARGETS = new ConcurrentHashMap<String, Class<? extends PathfinderAdapter>>();

    public VolatileAIHandler_v1_16_R2(VolatileCodeHandler handler) {
        Set<Class<?>> customGoalClasses = new VersionCompliantReflections("io.lumine.xikage.mythicmobs.mobs.ai.goals").getTypesAnnotatedWith(MythicAIGoal.class);
        for (Class<?> clazz : customGoalClasses) {
            try {
                String string = clazz.getAnnotation(MythicAIGoal.class).name();
                String[] stringArray = clazz.getAnnotation(MythicAIGoal.class).aliases();
                if (!PathfinderAdapter.class.isAssignableFrom(clazz)) continue;
                this.AI_GOALS.put(string.toUpperCase(), clazz);
                for (String alias : stringArray) {
                    this.AI_GOALS.put(alias.toUpperCase(), clazz);
                }
            }
            catch (Exception exception) {
                MythicLogger.error("Failed to load custom AI goal {0}", clazz.getCanonicalName());
            }
        }
        Set<Class<?>> wrappedGoalClasses = new VersionCompliantReflections("io.lumine.xikage.mythicmobs.volatilecode.v1_16_R2.ai.goals").getTypesAnnotatedWith(MythicAIGoal.class);
        for (Class<?> clazz : wrappedGoalClasses) {
            try {
                String string = clazz.getAnnotation(MythicAIGoal.class).name();
                String[] aliases = clazz.getAnnotation(MythicAIGoal.class).aliases();
                if (!PathfinderAdapter.class.isAssignableFrom(clazz)) continue;
                this.AI_GOALS.put(string.toUpperCase(), clazz);
                for (String alias : aliases) {
                    this.AI_GOALS.put(alias.toUpperCase(), clazz);
                }
            }
            catch (Exception exception) {
                MythicLogger.error("Failed to load wrapped AI goal {0}", clazz.getCanonicalName());
            }
        }
        Set<Class<?>> set = new VersionCompliantReflections("io.lumine.xikage.mythicmobs.mobs.ai.targeters").getTypesAnnotatedWith(MythicAIGoal.class);
        for (Class<?> clazz : set) {
            try {
                String name = clazz.getAnnotation(MythicAIGoal.class).name();
                String[] aliases = clazz.getAnnotation(MythicAIGoal.class).aliases();
                if (!PathfinderAdapter.class.isAssignableFrom(clazz)) continue;
                this.AI_TARGETS.put(name.toUpperCase(), clazz);
                for (String alias : aliases) {
                    this.AI_TARGETS.put(alias.toUpperCase(), clazz);
                }
            }
            catch (Exception ex) {
                MythicLogger.error("Failed to load custom AI targeter {0}", clazz.getCanonicalName());
            }
        }
        Set<Class<?>> set2 = new VersionCompliantReflections("io.lumine.xikage.mythicmobs.volatilecode.v1_16_R2.ai.targeters").getTypesAnnotatedWith(MythicAIGoal.class);
        for (Class<?> clazz : set2) {
            try {
                String name = clazz.getAnnotation(MythicAIGoal.class).name();
                String[] aliases = clazz.getAnnotation(MythicAIGoal.class).aliases();
                if (!PathfinderAdapter.class.isAssignableFrom(clazz)) continue;
                this.AI_TARGETS.put(name.toUpperCase(), clazz);
                for (String alias : aliases) {
                    this.AI_TARGETS.put(alias.toUpperCase(), clazz);
                }
            }
            catch (Exception ex) {
                MythicLogger.error("Failed to load wrapped AI targeter {0}", clazz.getCanonicalName());
            }
        }
    }

    @Override
    public void setTarget(LivingEntity entity, LivingEntity target) {
        if (entity instanceof Creature) {
            try {
                ((Creature)entity).setTarget(target);
            }
            catch (Exception exception) {}
        } else {
            try {
                ((EntityInsentient)((CraftLivingEntity)entity).getHandle()).setGoalTarget(((CraftLivingEntity)target).getHandle(), EntityTargetEvent.TargetReason.CUSTOM, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void navigateToLocation(AbstractEntity entity, AbstractLocation destination, double maxDistance) {
        if (!entity.isLiving()) {
            return;
        }
        EntityInsentient e = (EntityInsentient)((CraftLivingEntity)BukkitAdapter.adapt(entity)).getHandle();
        e.getNavigation().a(destination.getX(), destination.getY(), destination.getZ(), 1.0);
    }

    public void clearPathfinderGoals(AbstractEntity entity) {
        if (!entity.isLiving()) {
            return;
        }
        EntityInsentient e = (EntityInsentient)((CraftLivingEntity)BukkitAdapter.adapt(entity)).getHandle();
        PathfinderGoalSelector goals = (PathfinderGoalSelector)this.refEntityInsentient.get(e, "goalSelector");
        ((Map)this.refGoalSelector.get(goals, "c")).clear();
        ((Set)this.refGoalSelector.get(goals, "d")).clear();
    }

    public void clearPathfinderTargets(AbstractEntity entity) {
        if (!entity.isLiving()) {
            return;
        }
        EntityInsentient e = (EntityInsentient)((CraftLivingEntity)BukkitAdapter.adapt(entity)).getHandle();
        PathfinderGoalSelector goals = (PathfinderGoalSelector)this.refEntityInsentient.get(e, "targetSelector");
        ((Map)this.refGoalSelector.get(goals, "c")).clear();
        ((Set)this.refGoalSelector.get(goals, "d")).clear();
    }

    public void addPathfindersGoal(int index, AbstractEntity entity, PathfinderGoal goal, Predicate<AbstractEntity> validator) {
        block3: {
            if (validator != null && !validator.test(entity)) {
                return;
            }
            EntityInsentient nmsEntity = (EntityInsentient)((CraftLivingEntity)BukkitAdapter.adapt(entity)).getHandle();
            PathfinderGoalSelector goals = (PathfinderGoalSelector)this.refEntityInsentient.get(nmsEntity, "");
            try {
                goals.a(index, goal);
            }
            catch (Exception ex) {
                MythicLogger.error("Failed to apply pathfinder goal");
                if (ConfigManager.debugLevel <= 0) break block3;
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void addPathfinderGoals(LivingEntity entity, List<String> aiMods) {
        block70: {
            try {
                EntityInsentient e = (EntityInsentient)((CraftLivingEntity)entity).getHandle();
                PathfinderGoalSelector goals = (PathfinderGoalSelector)this.refEntityInsentient.get(e, "goalSelector");
                int i = 0;
                int j = 0;
                block55: for (String str : aiMods) {
                    String data2;
                    String data;
                    String goal;
                    ++i;
                    String[] split = str.split(" ");
                    if (split[0].matches("[0-9]*")) {
                        j = Integer.parseInt(split[0]);
                        goal = split[1];
                        data = split.length > 2 ? split[2] : null;
                        data2 = split.length > 3 ? split[3] : null;
                    } else {
                        j = i;
                        goal = split[0];
                        data = split.length > 1 ? split[1] : null;
                        data2 = split.length > 2 ? split[2] : null;
                    }
                    MythicLineConfig mlc = new MythicLineConfig(MythicLineConfig.unparseBlock(goal));
                    goal = mlc.getKey();
                    if (this.AI_GOALS.containsKey(goal.toUpperCase())) {
                        Class<? extends PathfinderAdapter> clazz = this.AI_GOALS.get(goal.toUpperCase());
                        try {
                            if (Pathfinder.class.isAssignableFrom(clazz)) {
                                Pathfinder pathfinder = (Pathfinder)clazz.getConstructor(AbstractEntity.class, String.class, MythicLineConfig.class).newInstance(BukkitAdapter.adapt((Entity)entity), str, mlc);
                                goals.a(j, CustomAIAdapter.create(pathfinder));
                                continue;
                            }
                            WrappedPathfinder wrappedPathfinder = (WrappedPathfinder)((Object)clazz.getConstructor(AbstractEntity.class, String.class, MythicLineConfig.class).newInstance(BukkitAdapter.adapt((Entity)entity), str, mlc));
                            PathfinderHolder holder = (PathfinderHolder)((Object)wrappedPathfinder);
                            if (holder.isValid()) {
                                PathfinderGoal pathfinder = holder.create();
                                goals.a(j, pathfinder);
                                continue;
                            }
                            MythicLogger.error("AI pathfinder {0} is not valid for this mob type", goal);
                            continue;
                        }
                        catch (Error | Exception ex) {
                            MythicLogger.error("Failed to construct AI pathfinder {0}", goal);
                            ex.printStackTrace();
                        }
                    }
                    switch (goal.toLowerCase()) {
                        case "reset": 
                        case "clear": {
                            ((Map)this.refGoalSelector.get(goals, "c")).clear();
                            ((Set)this.refGoalSelector.get(goals, "d")).clear();
                            continue block55;
                        }
                        case "arrowattack": {
                            if (!(e instanceof IRangedEntity)) continue block55;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalArrowAttack((IRangedEntity)e, 1.0, 20, 60, 15.0f));
                            continue block55;
                        }
                        case "skeletonbowattack": 
                        case "bowshoot": 
                        case "bowmaster": {
                            if (!(e instanceof IRangedEntity)) continue block55;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalBowShoot((EntityMonster)((EntitySkeleton)e), 1.0, 20, 15.0f));
                            continue block55;
                        }
                        case "breakdoor": {
                            goals.a(j, (PathfinderGoal)new PathfinderGoalBreakDoor(e, p -> true));
                            continue block55;
                        }
                        case "eatgrass": {
                            goals.a(j, (PathfinderGoal)new PathfinderGoalEatTile(e));
                            continue block55;
                        }
                        case "fleegolems": 
                        case "runfromgolems": {
                            if (!(e instanceof EntityCreature)) continue block55;
                            float distance = 16.0f;
                            double speed = 1.2;
                            if (data != null) {
                                distance = Float.valueOf(data).floatValue();
                            }
                            if (data2 != null) {
                                speed = Float.valueOf(data2).floatValue();
                            }
                            goals.a(j, (PathfinderGoal)new PathfinderGoalAvoidTarget((EntityCreature)e, EntityIronGolem.class, distance, 1.0, speed));
                            continue block55;
                        }
                        case "fleeplayers": 
                        case "runfromplayers": {
                            if (!(e instanceof EntityCreature)) continue block55;
                            float distance = 16.0f;
                            double speed = 1.2;
                            if (data != null) {
                                distance = Float.valueOf(data).floatValue();
                            }
                            if (data2 != null) {
                                speed = Float.valueOf(data2).floatValue();
                            }
                            goals.a(j, (PathfinderGoal)new PathfinderGoalAvoidTarget((EntityCreature)e, EntityHuman.class, distance, 1.0, speed));
                            continue block55;
                        }
                        case "fleevillagers": 
                        case "runfromvillagers": {
                            if (!(e instanceof EntityCreature)) continue block55;
                            float distance = 16.0f;
                            double speed = 1.2;
                            if (data != null) {
                                distance = Float.valueOf(data).floatValue();
                            }
                            if (data2 != null) {
                                speed = Float.valueOf(data2).floatValue();
                            }
                            goals.a(j, (PathfinderGoal)new PathfinderGoalAvoidTarget((EntityCreature)e, EntityVillager.class, distance, 1.0, speed));
                            continue block55;
                        }
                        case "fleewolves": 
                        case "runfromwolves": {
                            if (!(e instanceof EntityCreature)) continue block55;
                            float distance = 6.0f;
                            double speed = 1.2;
                            if (data != null) {
                                distance = Float.valueOf(data).floatValue();
                            }
                            if (data2 != null) {
                                speed = Float.valueOf(data2).floatValue();
                            }
                            goals.a(j, (PathfinderGoal)new PathfinderGoalAvoidTarget((EntityCreature)e, EntityWolf.class, distance, 1.0, speed));
                            continue block55;
                        }
                        case "fleesun": {
                            if (!(e instanceof EntityCreature)) continue block55;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalFleeSun((EntityCreature)e, 1.0));
                            continue block55;
                        }
                        case "float": 
                        case "swim": {
                            goals.a(j, (PathfinderGoal)new PathfinderGoalFloat(e));
                            continue block55;
                        }
                        case "lookatplayers": {
                            goals.a(j, (PathfinderGoal)new PathfinderGoalLookAtPlayer(e, EntityHuman.class, 5.0f, 1.0f));
                            continue block55;
                        }
                        case "leapattarget": {
                            float speed = 0.3f;
                            if (data != null) {
                                speed = Float.valueOf(data).floatValue();
                            }
                            goals.a(j, (PathfinderGoal)new PathfinderGoalLeapAtTarget(e, speed));
                            continue block55;
                        }
                        case "spiderattack": {
                            if (!(e instanceof EntityCreature)) continue block55;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalSpiderMeleeAttack((EntityCreature)e, EntityCreature.class));
                            continue block55;
                        }
                        case "movethroughvillage": {
                            if (!(e instanceof EntityCreature)) continue block55;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalMoveThroughVillage((EntityCreature)e, 0.6, false, 4, () -> false));
                            continue block55;
                        }
                        case "movetowardsrestriction": {
                            if (!(e instanceof EntityCreature)) continue block55;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalMoveTowardsRestriction((EntityCreature)e, 0.6));
                            continue block55;
                        }
                        case "opendoor": 
                        case "opendoors": {
                            goals.a(j, (PathfinderGoal)new PathfinderGoalDoorOpen(e, true));
                            continue block55;
                        }
                        case "panic": {
                            if (!(e instanceof EntityCreature)) continue block55;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalPanic((EntityCreature)e, 1.25));
                            continue block55;
                        }
                        case "restrictsun": {
                            if (!(e instanceof EntityCreature)) continue block55;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalRestrictSun((EntityCreature)e));
                            continue block55;
                        }
                    }
                }
            }
            catch (Exception ex) {
                MythicLogger.error("An error occurred while adding an AIGoalSelector, enable debugging for a stack trace.");
                if (ConfigManager.debugLevel <= 0) break block70;
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void addTargetGoals(LivingEntity entity, List<String> aiMods) {
        block35: {
            try {
                EntityInsentient e = (EntityInsentient)((CraftLivingEntity)entity).getHandle();
                PathfinderGoalSelector goals = (PathfinderGoalSelector)this.refEntityInsentient.get(e, "targetSelector");
                int i = 0;
                int j = 0;
                block29: for (String str : aiMods) {
                    String data;
                    String goal;
                    ++i;
                    String[] split = str.split(" ");
                    if (split[0].matches("[0-9]*")) {
                        j = Integer.parseInt(split[0]);
                        goal = split[1];
                        data = split.length > 2 ? split[2] : "";
                    } else {
                        j = i;
                        goal = split[0];
                        data = split.length > 1 ? split[1] : "";
                    }
                    MythicLineConfig mlc = new MythicLineConfig(goal);
                    goal = mlc.getKey();
                    if (this.AI_TARGETS.containsKey(goal.toUpperCase())) {
                        Class<? extends PathfinderAdapter> clazz = this.AI_TARGETS.get(goal.toUpperCase());
                        try {
                            if (clazz.isAssignableFrom(Pathfinder.class)) {
                                Pathfinder pathfinder = (Pathfinder)clazz.getConstructor(AbstractEntity.class, String.class, MythicLineConfig.class).newInstance(BukkitAdapter.adapt((Entity)entity), str, mlc);
                                goals.a(j, CustomAIAdapter.create(pathfinder));
                                continue;
                            }
                            WrappedPathfinder wrappedPathfinder = (WrappedPathfinder)((Object)clazz.getConstructor(AbstractEntity.class, String.class, MythicLineConfig.class).newInstance(BukkitAdapter.adapt((Entity)entity), str, mlc));
                            PathfinderHolder holder = (PathfinderHolder)((Object)wrappedPathfinder);
                            if (holder.isValid()) {
                                PathfinderGoal pathfinder = holder.create();
                                goals.a(j, pathfinder);
                                continue;
                            }
                            MythicLogger.error("AI pathfinder {0} is not valid for this mob type", goal);
                            continue;
                        }
                        catch (Error | Exception ex) {
                            MythicLogger.error("Failed to construct AI pathfinder {0}", goal);
                            ex.printStackTrace();
                        }
                    }
                    switch (goal.toLowerCase()) {
                        case "reset": 
                        case "clear": {
                            ((Map)this.refGoalSelector.get(goals, "c")).clear();
                            ((Set)this.refGoalSelector.get(goals, "d")).clear();
                            continue block29;
                        }
                        case "ownerhurttarget": 
                        case "ownertarget": {
                            if (!(e instanceof EntityTameableAnimal)) continue block29;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalOwnerHurtByTarget((EntityTameableAnimal)e));
                            continue block29;
                        }
                        case "monsters": {
                            if (!(e instanceof EntityCreature)) continue block29;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalNearestAttackableTarget((EntityInsentient)((EntityCreature)e), EntityInsentient.class, 0, true, false, entityliving -> entityliving instanceof IMonster));
                            continue block29;
                        }
                        case "players": {
                            if (!(e instanceof EntityCreature)) continue block29;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalNearestAttackableTarget((EntityInsentient)((EntityCreature)e), EntityHuman.class, true));
                            continue block29;
                        }
                        case "villagers": {
                            if (!(e instanceof EntityCreature)) continue block29;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalNearestAttackableTarget((EntityInsentient)((EntityCreature)e), EntityVillager.class, false));
                            continue block29;
                        }
                        case "iron_golems": 
                        case "golems": {
                            if (!(e instanceof EntityCreature)) continue block29;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalNearestAttackableTarget((EntityInsentient)((EntityCreature)e), EntityIronGolem.class, false));
                            continue block29;
                        }
                        case "otherfactionmonsters": {
                            if (!(e instanceof EntityCreature)) continue block29;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalNearestAttackableTarget((EntityInsentient)((EntityCreature)e), EntityInsentient.class, 0, true, false, targetEntity -> {
                                try {
                                    if (targetEntity instanceof IMonster) {
                                        UUID mobUUID = e.getUniqueID();
                                        UUID targetUUID = ((EntityInsentient)targetEntity).getUniqueID();
                                        Optional<ActiveMob> maybeMobT = MythicMobs.inst().getMobManager().getActiveMob(targetUUID);
                                        if (!maybeMobT.isPresent()) {
                                            return true;
                                        }
                                        Optional<ActiveMob> maybeMobC = MythicMobs.inst().getMobManager().getActiveMob(mobUUID);
                                        if (!maybeMobC.isPresent()) {
                                            return true;
                                        }
                                        ActiveMob casterAM = maybeMobC.get();
                                        ActiveMob targetAM = maybeMobT.get();
                                        if (targetAM.hasFaction()) {
                                            return !casterAM.getFaction().equals(targetAM.getFaction());
                                        }
                                        return true;
                                    }
                                    return false;
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                    return false;
                                }
                            }));
                            continue block29;
                        }
                        case "specificfaction": {
                            if (!(e instanceof EntityCreature)) continue block29;
                            String faction = data;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalNearestAttackableTarget((EntityInsentient)((EntityCreature)e), EntityInsentient.class, 0, true, false, targetEntity -> {
                                try {
                                    UUID mobUUID = e.getUniqueID();
                                    UUID targetUUID = ((EntityInsentient)targetEntity).getUniqueID();
                                    Optional<ActiveMob> maybeMob = MythicMobs.inst().getMobManager().getActiveMob(targetUUID);
                                    if (!maybeMob.isPresent()) {
                                        return true;
                                    }
                                    ActiveMob am = maybeMob.get();
                                    if (am.hasFaction()) {
                                        return am.getFaction().equals(faction);
                                    }
                                    return false;
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                    return false;
                                }
                            }));
                            continue block29;
                        }
                        case "specificfactionmonsters": {
                            if (!(e instanceof EntityCreature)) continue block29;
                            String faction = data;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalNearestAttackableTarget((EntityInsentient)((EntityCreature)e), EntityInsentient.class, 0, true, false, targetEntity -> {
                                try {
                                    if (targetEntity instanceof IMonster) {
                                        UUID mobUUID = e.getUniqueID();
                                        UUID targetUUID = ((EntityInsentient)targetEntity).getUniqueID();
                                        Optional<ActiveMob> maybeMob = MythicMobs.inst().getMobManager().getActiveMob(targetUUID);
                                        if (!maybeMob.isPresent()) {
                                            return true;
                                        }
                                        ActiveMob am = maybeMob.get();
                                        if (am.hasFaction()) {
                                            return am.getFaction().equals(faction);
                                        }
                                        return true;
                                    }
                                    return false;
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                    return false;
                                }
                            }));
                            continue block29;
                        }
                    }
                }
            }
            catch (Exception ex) {
                MythicLogger.error("An error has occurred, enable debugging for a stack trace.");
                if (ConfigManager.debugLevel <= 0) break block35;
                ex.printStackTrace();
            }
        }
    }

    static class PathfinderGoalSpiderMeleeAttack
    extends PathfinderGoalMeleeAttack {
        public PathfinderGoalSpiderMeleeAttack(EntityCreature entity, Class<? extends net.minecraft.server.v1_16_R2.Entity> oclass) {
            super(entity, 1.0, true);
        }

        public boolean b() {
            return super.b();
        }

        protected double a(EntityLiving entityliving) {
            return 4.0f + entityliving.getWidth();
        }
    }
}

