/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.volatilecode.v1_16_R2;

import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.utils.tasks.Scheduler;
import io.lumine.xikage.mythicmobs.volatilecode.VolatileCodeHandler;
import io.lumine.xikage.mythicmobs.volatilecode.handlers.VolatileBlockHandler;
import net.minecraft.server.v1_16_R2.Block;
import net.minecraft.server.v1_16_R2.BlockPiston;
import net.minecraft.server.v1_16_R2.BlockPosition;
import net.minecraft.server.v1_16_R2.EnumDirection;
import net.minecraft.server.v1_16_R2.IBlockData;
import net.minecraft.server.v1_16_R2.World;
import net.minecraft.server.v1_16_R2.WorldServer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Powerable;
import org.bukkit.block.data.type.Piston;
import org.bukkit.craftbukkit.v1_16_R2.CraftWorld;

public class VolatileBlockHandler_v1_16_R2
implements VolatileBlockHandler {
    public VolatileBlockHandler_v1_16_R2(VolatileCodeHandler handler) {
    }

    @Override
    public void applyPhysics(org.bukkit.block.Block target) {
        Location location = target.getLocation();
        WorldServer world = ((CraftWorld)location.getWorld()).getHandle();
        BlockPosition blockposition = new BlockPosition(location.getX(), location.getY(), location.getZ());
        IBlockData iblockdata = world.getType(blockposition);
        Block block = iblockdata.getBlock();
        world.applyPhysics(blockposition, block);
    }

    @Override
    public void togglePowerable(AbstractLocation location) {
        this.togglePowerable(location, 0L);
    }

    @Override
    public void togglePowerable(AbstractLocation location, long duration) {
        Location l = BukkitAdapter.adapt(location);
        org.bukkit.block.Block block = l.getWorld().getBlockAt(l);
        BlockData bd = block.getBlockData();
        if (bd instanceof Powerable) {
            Powerable pbd = (Powerable)bd;
            pbd.setPowered(true);
            block.setBlockData((BlockData)pbd);
            this.applyPhysics(block);
            Scheduler.runLaterSync(() -> {
                pbd.setPowered(false);
                block.setBlockData((BlockData)pbd);
                this.applyPhysics(block);
            }, duration);
        }
    }

    @Override
    public void togglePiston(AbstractLocation target) {
        Location location = BukkitAdapter.adapt(target);
        org.bukkit.block.Block block = location.getBlock();
        if (block.getType() != Material.PISTON) {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Location was not piston", new Object[0]);
            return;
        }
        BlockData bd = block.getBlockData();
        Piston redstone = (Piston)bd;
        boolean extended = redstone.isExtended();
        BlockFace bf = ((Directional)bd).getFacing();
        if (extended) {
            redstone.setExtended(false);
            block.setBlockData((BlockData)redstone);
        }
        redstone.setExtended(true);
        block.setBlockData((BlockData)redstone);
        WorldServer world = ((CraftWorld)location.getWorld()).getHandle();
        BlockPosition blockposition = new BlockPosition(location.getX(), location.getY(), location.getZ());
        IBlockData iblockdata = world.getType(blockposition);
        boolean bold = BlockPiston.a((IBlockData)iblockdata, (World)world, (BlockPosition)blockposition, (EnumDirection)EnumDirection.DOWN, (boolean)true, (EnumDirection)EnumDirection.DOWN);
        if (!bold) {
            redstone.setExtended(false);
            block.setBlockData((BlockData)redstone);
        }
    }
}

