/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.worlds;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.SerializingComponent;
import io.lumine.xikage.mythicmobs.adapters.AbstractWorld;
import io.lumine.xikage.mythicmobs.utils.serialization.WrappedJsonFile;
import io.lumine.xikage.mythicmobs.worlds.WorldData;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class WorldManager
extends SerializingComponent {
    protected Map<String, WrappedJsonFile<WorldData>> worldData;

    public WorldManager(MythicMobs core) {
        super(core);
    }

    @Override
    public void load(MythicMobs plugin) {
        this.worldData = new ConcurrentHashMap<String, WrappedJsonFile<WorldData>>();
        for (File file : this.getModuleFiles("worlds")) {
            if (!file.getName().endsWith(".json")) continue;
            try {
                String worldName = file.getName().split("\\.")[0];
                WrappedJsonFile<WorldData> loaded = this.loadFile(file, WorldData.class);
                if (loaded == null) continue;
                this.worldData.put(worldName, loaded);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void unload() {
        this.worldData.forEach((uuid, file) -> {
            if (file == null) {
                return;
            }
            ((WorldData)file.get()).getVariables().unload();
            file.save();
        });
    }

    public WorldData getWorldData(AbstractWorld world) {
        if (!this.worldData.containsKey(world.getName())) {
            WrappedJsonFile<WorldData> f = new WrappedJsonFile<WorldData>(this, new File(this.getBasedir(), "worlds/" + world.getName() + ".json"), new WorldData(world));
            this.worldData.put(world.getName(), f);
        }
        return this.worldData.get(world.getName()).get();
    }

    public void saveAll() {
        this.worldData.forEach((uuid, file) -> {
            if (file == null) {
                return;
            }
            ((WorldData)file.get()).getVariables().clean();
            file.save();
        });
    }
}

