/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.notification;

import com.volmit.adapt.api.notification.Notification;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.util.RNG;
import com.volmit.adapt.util.advancements.NameKey;
import com.volmit.adapt.util.advancements.advancement.Advancement;
import com.volmit.adapt.util.advancements.advancement.AdvancementDisplay;
import com.volmit.adapt.util.advancements.advancement.AdvancementFlag;
import com.volmit.adapt.util.advancements.advancement.AdvancementVisibility;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Material;

public class AdvancementNotification
implements Notification {
    private final Material icon;
    private final String title;
    private final String description;
    private final AdvancementDisplay.AdvancementFrame frameType;
    private final String group;

    @Override
    public long getTotalDuration() {
        return 100L;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public void play(AdaptPlayer adaptPlayer) {
        AdvancementDisplay advancementDisplay = new AdvancementDisplay(this.icon, this.buildTitle(), this.description, this.frameType, AdvancementVisibility.ALWAYS);
        Advancement advancement = new Advancement(null, new NameKey("adapt-notifications", "n" + adaptPlayer.getId() + RNG.r.lmax()), advancementDisplay, new AdvancementFlag[0]);
        if (adaptPlayer.getPlayer() != null) {
            advancement.displayToast(adaptPlayer.getPlayer());
        }
    }

    public String buildTitle() {
        if (this.description.trim().isEmpty()) {
            return this.title;
        }
        return this.title + "\n" + this.description;
    }

    private static Material $default$icon() {
        return Material.DIAMOND;
    }

    private static String $default$title() {
        return " ";
    }

    private static String $default$description() {
        return " ";
    }

    private static AdvancementDisplay.AdvancementFrame $default$frameType() {
        return AdvancementDisplay.AdvancementFrame.TASK;
    }

    private static String $default$group() {
        return "default";
    }

    AdvancementNotification(Material material, String string, String string2, AdvancementDisplay.AdvancementFrame advancementFrame, String string3) {
        this.icon = material;
        this.title = string;
        this.description = string2;
        this.frameType = advancementFrame;
        this.group = string3;
    }

    public static AdvancementNotificationBuilder builder() {
        return new AdvancementNotificationBuilder();
    }

    public Material getIcon() {
        return this.icon;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public AdvancementDisplay.AdvancementFrame getFrameType() {
        return this.frameType;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AdvancementNotification)) {
            return false;
        }
        AdvancementNotification advancementNotification = (AdvancementNotification)object;
        if (!advancementNotification.canEqual(this)) {
            return false;
        }
        Material material = this.getIcon();
        Material material2 = advancementNotification.getIcon();
        if (material == null ? material2 != null : !material.equals(material2)) {
            return false;
        }
        String string = this.getTitle();
        String string2 = advancementNotification.getTitle();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        String string3 = this.getDescription();
        String string4 = advancementNotification.getDescription();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        AdvancementDisplay.AdvancementFrame advancementFrame = this.getFrameType();
        AdvancementDisplay.AdvancementFrame advancementFrame2 = advancementNotification.getFrameType();
        if (advancementFrame == null ? advancementFrame2 != null : !((Object)((Object)advancementFrame)).equals((Object)advancementFrame2)) {
            return false;
        }
        String string5 = this.getGroup();
        String string6 = advancementNotification.getGroup();
        return !(string5 == null ? string6 != null : !string5.equals(string6));
    }

    protected boolean canEqual(Object object) {
        return object instanceof AdvancementNotification;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        Material material = this.getIcon();
        n2 = n2 * 59 + (material == null ? 43 : material.hashCode());
        String string = this.getTitle();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        String string2 = this.getDescription();
        n2 = n2 * 59 + (string2 == null ? 43 : string2.hashCode());
        AdvancementDisplay.AdvancementFrame advancementFrame = this.getFrameType();
        n2 = n2 * 59 + (advancementFrame == null ? 43 : ((Object)((Object)advancementFrame)).hashCode());
        String string3 = this.getGroup();
        n2 = n2 * 59 + (string3 == null ? 43 : string3.hashCode());
        return n2;
    }

    public String toString() {
        return "AdvancementNotification(icon=" + this.getIcon() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", frameType=" + this.getFrameType() + ", group=" + this.getGroup() + ")";
    }

    static {
        IBootstrap.dasBoot();
    }

    public static class AdvancementNotificationBuilder {
        private boolean icon$set;
        private Material icon$value;
        private boolean title$set;
        private String title$value;
        private boolean description$set;
        private String description$value;
        private boolean frameType$set;
        private AdvancementDisplay.AdvancementFrame frameType$value;
        private boolean group$set;
        private String group$value;

        AdvancementNotificationBuilder() {
        }

        public AdvancementNotificationBuilder icon(Material material) {
            this.icon$value = material;
            this.icon$set = true;
            return this;
        }

        public AdvancementNotificationBuilder title(String string) {
            this.title$value = string;
            this.title$set = true;
            return this;
        }

        public AdvancementNotificationBuilder description(String string) {
            this.description$value = string;
            this.description$set = true;
            return this;
        }

        public AdvancementNotificationBuilder frameType(AdvancementDisplay.AdvancementFrame advancementFrame) {
            this.frameType$value = advancementFrame;
            this.frameType$set = true;
            return this;
        }

        public AdvancementNotificationBuilder group(String string) {
            this.group$value = string;
            this.group$set = true;
            return this;
        }

        public AdvancementNotification build() {
            Material material = this.icon$value;
            if (!this.icon$set) {
                material = AdvancementNotification.$default$icon();
            }
            String string = this.title$value;
            if (!this.title$set) {
                string = AdvancementNotification.$default$title();
            }
            String string2 = this.description$value;
            if (!this.description$set) {
                string2 = AdvancementNotification.$default$description();
            }
            AdvancementDisplay.AdvancementFrame advancementFrame = this.frameType$value;
            if (!this.frameType$set) {
                advancementFrame = AdvancementNotification.$default$frameType();
            }
            String string3 = this.group$value;
            if (!this.group$set) {
                string3 = AdvancementNotification.$default$group();
            }
            return new AdvancementNotification(material, string, string2, advancementFrame, string3);
        }

        public String toString() {
            return "AdvancementNotification.AdvancementNotificationBuilder(icon$value=" + this.icon$value + ", title$value=" + this.title$value + ", description$value=" + this.description$value + ", frameType$value=" + this.frameType$value + ", group$value=" + this.group$value + ")";
        }

        static {
            IBootstrap.dasBoot();
        }
    }
}

