/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.potion;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.potion.BrewingRecipe;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.BrewingStand;
import org.bukkit.entity.Player;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BrewingTask
extends BukkitRunnable {
    private static final int DEFAULT_BREW_TIME = 400;
    private final BrewingRecipe recipe;
    private final Location location;
    private int brewTime;

    public BrewingTask(BrewingRecipe brewingRecipe, Location location) {
        this.recipe = brewingRecipe;
        this.location = location;
        this.brewTime = brewingRecipe.getBrewingTime();
        BrewingStand brewingStand = (BrewingStand)location.getBlock().getState();
        if (brewingStand.getFuelLevel() > brewingRecipe.getFuelCost()) {
            brewingStand.setFuelLevel(brewingStand.getFuelLevel() - brewingRecipe.getFuelCost());
        } else {
            int n = brewingRecipe.getFuelCost() - brewingStand.getFuelLevel();
            brewingStand.getInventory().setIngredient(BrewingTask.decrease(brewingStand.getInventory().getFuel(), 1 + n / 20));
            brewingStand.setFuelLevel(20 - n % 20);
        }
        brewingStand.setBrewingTime(400);
        brewingStand.update(true);
        this.runTaskTimer((Plugin)Adapt.instance, 0L, 1L);
    }

    public static ItemStack decrease(ItemStack itemStack, int n) {
        if (itemStack.getAmount() > n) {
            itemStack.setAmount(itemStack.getAmount() - n);
            return itemStack;
        }
        return new ItemStack(Material.AIR);
    }

    public static boolean isValid(BrewingRecipe brewingRecipe, Location location) {
        BrewingStand brewingStand = (BrewingStand)location.getBlock().getState();
        BrewerInventory brewerInventory = brewingStand.getInventory();
        if (brewerInventory.getIngredient() == null || brewingRecipe.getIngredient() != brewerInventory.getIngredient().getType()) {
            return false;
        }
        int n = (brewerInventory.getFuel() != null && brewerInventory.getFuel().getType() != Material.AIR ? brewerInventory.getFuel().getAmount() * 20 : 0) + brewingStand.getFuelLevel();
        if (n < brewingRecipe.getFuelCost()) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            if (!brewingRecipe.getBasePotion().isSimilar(brewerInventory.getItem(i))) continue;
            return true;
        }
        return false;
    }

    public void run() {
        BrewingStand brewingStand = (BrewingStand)this.location.getBlock().getState();
        BrewerInventory brewerInventory = brewingStand.getInventory();
        if (this.brewTime <= 0) {
            brewerInventory.setIngredient(BrewingTask.decrease(brewerInventory.getIngredient(), 1));
            for (int i = 0; i < 3; ++i) {
                if (!this.recipe.getBasePotion().equals((Object)brewerInventory.getItem(i))) continue;
                brewerInventory.setItem(i, this.recipe.getResult());
            }
            brewerInventory.getViewers().forEach(humanEntity -> {
                if (humanEntity instanceof Player) {
                    Player player = (Player)humanEntity;
                    player.playSound(brewingStand.getLocation(), Sound.BLOCK_BREWING_STAND_BREW, 1.0f, 1.0f);
                }
            });
            this.cancel();
            return;
        }
        --this.brewTime;
        brewingStand.setBrewingTime(this.getRemainingTime());
        brewingStand.update(true);
    }

    private int getRemainingTime() {
        return (int)(400.0f * ((float)this.brewTime / (float)this.recipe.getBrewingTime()));
    }

    public BrewingRecipe getRecipe() {
        return this.recipe;
    }

    static {
        IBootstrap.dasBoot();
    }
}

