/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.skill;

import com.google.gson.Gson;
import com.volmit.adapt.Adapt;
import com.volmit.adapt.AdaptConfig;
import com.volmit.adapt.api.adaptation.Adaptation;
import com.volmit.adapt.api.advancement.AdaptAdvancement;
import com.volmit.adapt.api.recipe.AdaptRecipe;
import com.volmit.adapt.api.skill.Skill;
import com.volmit.adapt.api.tick.Ticked;
import com.volmit.adapt.api.tick.TickedObject;
import com.volmit.adapt.api.world.AdaptStatTracker;
import com.volmit.adapt.content.item.ItemListings;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.IO;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.JSONObject;
import com.volmit.adapt.util.advancements.advancement.AdvancementVisibility;
import com.volmit.adapt.util.arcane.amulet.io.FileWatcher;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;

public abstract class SimpleSkill<T>
extends TickedObject
implements Skill<T> {
    private final String name;
    private final String emojiName;
    private C color;
    private double minXp;
    private String description;
    private String displayName;
    private Material icon;
    private List<Adaptation<?>> adaptations;
    private List<AdaptStatTracker> statTrackers = new ArrayList<AdaptStatTracker>();
    private List<AdaptAdvancement> cachedAdvancements;
    private String advancementBackground;
    private List<AdaptRecipe> recipes = new ArrayList<AdaptRecipe>();
    private Class<T> configType;
    private T config;

    public SimpleSkill(String string, String string2) {
        super("skill", UUID.randomUUID() + "-skill-" + string, 50L);
        this.cachedAdvancements = new ArrayList<AdaptAdvancement>();
        this.emojiName = string2;
        this.adaptations = new ArrayList();
        this.setColor(C.WHITE);
        this.name = string;
        this.setIcon(Material.BOOK);
        this.setDescription("No Description Provided");
        this.setMinXp(100.0);
        this.setAdvancementBackground("minecraft:textures/block/deepslate_tiles.png");
        J.a(() -> {
            J.attempt(this::getConfig);
            this.getAdaptations().forEach(adaptation -> J.attempt(adaptation::getConfig));
        }, 1);
    }

    @Override
    public Class<T> getConfigurationClass() {
        return this.configType;
    }

    @Override
    public void registerConfiguration(Class<T> clazz) {
        this.configType = clazz;
        final File file = Adapt.instance.getDataFile(new String[]{"adapt", "skills", this.getName() + ".json"});
        final FileWatcher fileWatcher = new FileWatcher(file);
        fileWatcher.checkModified();
        J.a(() -> {
            fileWatcher.checkModified();
            Adapt.instance.getTicker().register(new TickedObject("config", "config-" + this.getName(), 1000L){

                @Override
                public void onTick() {
                    if (fileWatcher.checkModified() && file.exists()) {
                        SimpleSkill.this.config = null;
                        SimpleSkill.this.getConfig();
                        Adapt.info("Hotloaded " + file.getPath());
                        Adapt.hotloaded();
                        fileWatcher.checkModified();
                    }
                }
            });
        }, 20);
    }

    @Override
    public T getConfig() {
        block7: {
            try {
                if (this.config != null) break block7;
                T t = this.getConfigurationClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                File file = Adapt.instance.getDataFile(new String[]{"adapt", "skills", this.getName() + ".json"});
                if (!file.exists()) {
                    try {
                        IO.writeAll(file, new JSONObject(new Gson().toJson(t)).toString(4));
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        this.config = t;
                        return this.config;
                    }
                }
                try {
                    this.config = new Gson().fromJson(IO.readAll(file), this.getConfigurationClass());
                    IO.writeAll(file, new JSONObject(new Gson().toJson(this.config)).toString(4));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    this.config = t;
                    return this.config;
                }
            }
            catch (Throwable throwable) {
                Adapt.verbose("Failed to load config for " + this.getName());
            }
        }
        return this.config;
    }

    public void registerRecipe(AdaptRecipe adaptRecipe) {
        this.recipes.add(adaptRecipe);
    }

    public void registerAdvancement(AdaptAdvancement adaptAdvancement) {
        this.cachedAdvancements.add(adaptAdvancement);
    }

    public boolean checkValidEntity(EntityType entityType) {
        if (!entityType.isAlive()) {
            return false;
        }
        return !ItemListings.getInvalidDamageableEntities().contains(entityType);
    }

    protected boolean shouldReturnForPlayer(Player player) {
        if (player == null) {
            return true;
        }
        Adapt.verbose("Checking " + player.getName() + " for " + this.getName());
        return !this.isEnabled() || this.hasBlacklistPermission(player, this) || this.isWorldBlacklisted(player) || this.isInCreativeOrSpectator(player);
    }

    protected void shouldReturnForPlayer(Player player, Runnable runnable) {
        if (this.shouldReturnForPlayer(player)) {
            return;
        }
        runnable.run();
    }

    protected void shouldReturnForPlayer(Player player, Cancellable cancellable, Runnable runnable) {
        if (cancellable.isCancelled()) {
            return;
        }
        if (this.shouldReturnForPlayer(player)) {
            return;
        }
        runnable.run();
    }

    protected boolean shouldReturnForWorld(World world, Skill skill) {
        return !skill.isEnabled() || AdaptConfig.get().blacklistedWorlds.contains(world.getName());
    }

    protected boolean isWorldBlacklisted(Player player) {
        return AdaptConfig.get().blacklistedWorlds.contains(player.getWorld().getName());
    }

    protected boolean isInCreativeOrSpectator(Player player) {
        return !AdaptConfig.get().isXpInCreative() && (player.getGameMode().equals((Object)GameMode.CREATIVE) || player.getGameMode().equals((Object)GameMode.SPECTATOR));
    }

    @Override
    public String getDisplayName() {
        return this.displayName == null ? Skill.super.getDisplayName() : C.RESET + C.BOLD + this.getColor().toString() + this.getEmojiName() + " " + this.displayName;
    }

    @Override
    public void onRegisterAdvancements(List<AdaptAdvancement> list) {
        list.addAll(this.cachedAdvancements);
    }

    @Override
    public AdaptAdvancement buildAdvancements() {
        ArrayList<AdaptAdvancement> arrayList = new ArrayList<AdaptAdvancement>();
        this.onRegisterAdvancements(arrayList);
        for (Adaptation<?> adaptation : this.getAdaptations()) {
            arrayList.add(adaptation.buildAdvancements());
        }
        return AdaptAdvancement.builder().background(this.getAdvancementBackground()).key("skill_" + this.getName()).title(this.displayName).description(this.getDescription()).icon(this.getIcon()).children(arrayList).visibility(AdvancementVisibility.HIDDEN).build();
    }

    @Override
    public void registerStatTracker(AdaptStatTracker adaptStatTracker) {
        this.getStatTrackers().add(adaptStatTracker);
    }

    @Override
    public List<AdaptStatTracker> getStatTrackers() {
        return this.statTrackers;
    }

    @Override
    public void registerAdaptation(Adaptation<?> adaptation) {
        if (!adaptation.isEnabled()) {
            return;
        }
        adaptation.setSkill(this);
        this.adaptations.add(adaptation);
    }

    @Override
    public void unregister() {
        this.adaptations.forEach(Ticked::unregister);
    }

    @Override
    public abstract void onTick();

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SimpleSkill)) {
            return false;
        }
        SimpleSkill simpleSkill = (SimpleSkill)object;
        if (!simpleSkill.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getMinXp(), simpleSkill.getMinXp()) != 0) {
            return false;
        }
        String string = this.getName();
        String string2 = simpleSkill.getName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        String string3 = this.getEmojiName();
        String string4 = simpleSkill.getEmojiName();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        C c = this.getColor();
        C c2 = simpleSkill.getColor();
        if (c == null ? c2 != null : !((Object)((Object)c)).equals((Object)c2)) {
            return false;
        }
        String string5 = this.getDescription();
        String string6 = simpleSkill.getDescription();
        if (string5 == null ? string6 != null : !string5.equals(string6)) {
            return false;
        }
        String string7 = this.getDisplayName();
        String string8 = simpleSkill.getDisplayName();
        if (string7 == null ? string8 != null : !string7.equals(string8)) {
            return false;
        }
        Material material = this.getIcon();
        Material material2 = simpleSkill.getIcon();
        if (material == null ? material2 != null : !material.equals(material2)) {
            return false;
        }
        List<AdaptStatTracker> list = this.getStatTrackers();
        List<AdaptStatTracker> list2 = simpleSkill.getStatTrackers();
        if (list == null ? list2 != null : !((Object)list).equals(list2)) {
            return false;
        }
        List<AdaptAdvancement> list3 = this.getCachedAdvancements();
        List<AdaptAdvancement> list4 = simpleSkill.getCachedAdvancements();
        if (list3 == null ? list4 != null : !((Object)list3).equals(list4)) {
            return false;
        }
        String string9 = this.getAdvancementBackground();
        String string10 = simpleSkill.getAdvancementBackground();
        if (string9 == null ? string10 != null : !string9.equals(string10)) {
            return false;
        }
        List<AdaptRecipe> list5 = this.getRecipes();
        List<AdaptRecipe> list6 = simpleSkill.getRecipes();
        if (list5 == null ? list6 != null : !((Object)list5).equals(list6)) {
            return false;
        }
        Class<T> clazz = this.getConfigType();
        Class<T> clazz2 = simpleSkill.getConfigType();
        if (clazz == null ? clazz2 != null : !clazz.equals(clazz2)) {
            return false;
        }
        T t = this.getConfig();
        T t2 = simpleSkill.getConfig();
        return !(t == null ? t2 != null : !t.equals(t2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof SimpleSkill;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        long l = Double.doubleToLongBits(this.getMinXp());
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        String string = this.getName();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        String string2 = this.getEmojiName();
        n2 = n2 * 59 + (string2 == null ? 43 : string2.hashCode());
        C c = this.getColor();
        n2 = n2 * 59 + (c == null ? 43 : ((Object)((Object)c)).hashCode());
        String string3 = this.getDescription();
        n2 = n2 * 59 + (string3 == null ? 43 : string3.hashCode());
        String string4 = this.getDisplayName();
        n2 = n2 * 59 + (string4 == null ? 43 : string4.hashCode());
        Material material = this.getIcon();
        n2 = n2 * 59 + (material == null ? 43 : material.hashCode());
        List<AdaptStatTracker> list = this.getStatTrackers();
        n2 = n2 * 59 + (list == null ? 43 : ((Object)list).hashCode());
        List<AdaptAdvancement> list2 = this.getCachedAdvancements();
        n2 = n2 * 59 + (list2 == null ? 43 : ((Object)list2).hashCode());
        String string5 = this.getAdvancementBackground();
        n2 = n2 * 59 + (string5 == null ? 43 : string5.hashCode());
        List<AdaptRecipe> list3 = this.getRecipes();
        n2 = n2 * 59 + (list3 == null ? 43 : ((Object)list3).hashCode());
        Class<T> clazz = this.getConfigType();
        n2 = n2 * 59 + (clazz == null ? 43 : clazz.hashCode());
        T t = this.getConfig();
        n2 = n2 * 59 + (t == null ? 43 : t.hashCode());
        return n2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getEmojiName() {
        return this.emojiName;
    }

    @Override
    public C getColor() {
        return this.color;
    }

    @Override
    public double getMinXp() {
        return this.minXp;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Material getIcon() {
        return this.icon;
    }

    @Override
    public List<Adaptation<?>> getAdaptations() {
        return this.adaptations;
    }

    public List<AdaptAdvancement> getCachedAdvancements() {
        return this.cachedAdvancements;
    }

    public String getAdvancementBackground() {
        return this.advancementBackground;
    }

    @Override
    public List<AdaptRecipe> getRecipes() {
        return this.recipes;
    }

    public Class<T> getConfigType() {
        return this.configType;
    }

    public void setColor(C c) {
        this.color = c;
    }

    public void setMinXp(double d) {
        this.minXp = d;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public void setIcon(Material material) {
        this.icon = material;
    }

    public void setAdaptations(List<Adaptation<?>> list) {
        this.adaptations = list;
    }

    public void setStatTrackers(List<AdaptStatTracker> list) {
        this.statTrackers = list;
    }

    public void setCachedAdvancements(List<AdaptAdvancement> list) {
        this.cachedAdvancements = list;
    }

    public void setAdvancementBackground(String string) {
        this.advancementBackground = string;
    }

    public void setRecipes(List<AdaptRecipe> list) {
        this.recipes = list;
    }

    public void setConfigType(Class<T> clazz) {
        this.configType = clazz;
    }

    public void setConfig(T t) {
        this.config = t;
    }

    public String toString() {
        return "SimpleSkill(name=" + this.getName() + ", emojiName=" + this.getEmojiName() + ", color=" + this.getColor() + ", minXp=" + this.getMinXp() + ", description=" + this.getDescription() + ", displayName=" + this.getDisplayName() + ", icon=" + this.getIcon() + ", adaptations=" + this.getAdaptations() + ", statTrackers=" + this.getStatTrackers() + ", cachedAdvancements=" + this.getCachedAdvancements() + ", advancementBackground=" + this.getAdvancementBackground() + ", recipes=" + this.getRecipes() + ", configType=" + this.getConfigType() + ", config=" + this.getConfig() + ")";
    }

    static {
        IBootstrap.dasBoot();
    }
}

