/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.world;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.api.world.AdaptServer;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public interface AdaptComponent {
    default public AdaptServer getServer() {
        return Adapt.instance.getAdaptServer();
    }

    default public AdaptPlayer getPlayer(Player p) {
        return this.getServer().getPlayer(p);
    }

    default public boolean isItem(ItemStack is) {
        return is != null && !is.getType().equals((Object)Material.AIR);
    }

    default public boolean isTool(ItemStack is) {
        return this.isAxe(is) || this.isPickaxe(is) || this.isHoe(is) || this.isShovel(is) || this.isSword(is) || this.isTrident(is);
    }

    default public boolean isMelee(ItemStack is) {
        return this.isTool(is);
    }

    default public boolean isXpBlock(Material material) {
        return material.equals((Object)Material.EXPERIENCE_BOTTLE);
    }

    default public boolean isRanged(ItemStack it) {
        if (this.isItem(it)) {
            return switch (it.getType()) {
                case Material.BOW, Material.CROSSBOW -> true;
                default -> false;
            };
        }
        return false;
    }

    default public boolean isSword(ItemStack it) {
        if (this.isItem(it)) {
            return switch (it.getType()) {
                case Material.DIAMOND_SWORD, Material.GOLDEN_SWORD, Material.IRON_SWORD, Material.NETHERITE_SWORD, Material.STONE_SWORD, Material.WOODEN_SWORD -> true;
                default -> false;
            };
        }
        return false;
    }

    default public boolean isTrident(ItemStack it) {
        if (this.isItem(it)) {
            return switch (it.getType()) {
                case Material.TRIDENT, Material.SEA_PICKLE -> true;
                default -> false;
            };
        }
        return false;
    }

    default public boolean isAxe(ItemStack it) {
        if (this.isItem(it)) {
            return switch (it.getType()) {
                case Material.DIAMOND_AXE, Material.GOLDEN_AXE, Material.IRON_AXE, Material.NETHERITE_AXE, Material.STONE_AXE, Material.WOODEN_AXE -> true;
                default -> false;
            };
        }
        return false;
    }

    default public boolean isPickaxe(ItemStack it) {
        if (this.isItem(it)) {
            return switch (it.getType()) {
                case Material.DIAMOND_PICKAXE, Material.GOLDEN_PICKAXE, Material.IRON_PICKAXE, Material.NETHERITE_PICKAXE, Material.STONE_PICKAXE, Material.WOODEN_PICKAXE -> true;
                default -> false;
            };
        }
        return false;
    }

    default public boolean isShovel(ItemStack it) {
        if (this.isItem(it)) {
            return switch (it.getType()) {
                case Material.DIAMOND_SHOVEL, Material.GOLDEN_SHOVEL, Material.IRON_SHOVEL, Material.NETHERITE_SHOVEL, Material.STONE_SHOVEL, Material.WOODEN_SHOVEL -> true;
                default -> false;
            };
        }
        return false;
    }

    default public boolean isLog(ItemStack it) {
        if (this.isItem(it)) {
            return switch (it.getType()) {
                case Material.ACACIA_LOG, Material.BIRCH_LOG, Material.DARK_OAK_LOG, Material.JUNGLE_LOG, Material.OAK_LOG, Material.SPRUCE_LOG, Material.STRIPPED_ACACIA_LOG, Material.STRIPPED_BIRCH_LOG, Material.STRIPPED_DARK_OAK_LOG, Material.STRIPPED_JUNGLE_LOG, Material.STRIPPED_OAK_LOG, Material.STRIPPED_SPRUCE_LOG, Material.ACACIA_WOOD, Material.BIRCH_WOOD, Material.DARK_OAK_WOOD, Material.JUNGLE_WOOD, Material.OAK_WOOD, Material.SPRUCE_WOOD, Material.STRIPPED_ACACIA_WOOD, Material.STRIPPED_BIRCH_WOOD, Material.STRIPPED_DARK_OAK_WOOD, Material.STRIPPED_JUNGLE_WOOD, Material.STRIPPED_OAK_WOOD, Material.STRIPPED_SPRUCE_WOOD, Material.MUSHROOM_STEM, Material.BROWN_MUSHROOM_BLOCK, Material.RED_MUSHROOM_BLOCK, Material.MANGROVE_LOG, Material.MANGROVE_ROOTS, Material.MUDDY_MANGROVE_ROOTS, Material.STRIPPED_MANGROVE_LOG, Material.MANGROVE_WOOD, Material.STRIPPED_MANGROVE_WOOD -> true;
                default -> false;
            };
        }
        return false;
    }

    default public boolean isLeaves(ItemStack it) {
        if (this.isItem(it)) {
            return switch (it.getType()) {
                case Material.MANGROVE_ROOTS, Material.MUDDY_MANGROVE_ROOTS, Material.OAK_LEAVES, Material.SPRUCE_LEAVES, Material.BIRCH_LEAVES, Material.JUNGLE_LEAVES, Material.ACACIA_LEAVES, Material.DARK_OAK_LEAVES, Material.MANGROVE_LEAVES, Material.AZALEA_LEAVES, Material.FLOWERING_AZALEA_LEAVES -> true;
                default -> false;
            };
        }
        return false;
    }

    default public boolean isBoots(ItemStack it) {
        if (this.isItem(it)) {
            return switch (it.getType()) {
                case Material.DIAMOND_BOOTS, Material.GOLDEN_BOOTS, Material.IRON_BOOTS, Material.NETHERITE_BOOTS, Material.CHAINMAIL_BOOTS, Material.LEATHER_BOOTS -> true;
                default -> false;
            };
        }
        return false;
    }

    default public boolean isHelmet(ItemStack it) {
        if (this.isItem(it)) {
            return switch (it.getType()) {
                case Material.CHAINMAIL_HELMET, Material.DIAMOND_HELMET, Material.GOLDEN_HELMET, Material.IRON_HELMET, Material.LEATHER_HELMET, Material.NETHERITE_HELMET, Material.TURTLE_HELMET -> true;
                default -> false;
            };
        }
        return false;
    }

    default public boolean isLeggings(ItemStack it) {
        if (this.isItem(it)) {
            return switch (it.getType()) {
                case Material.DIAMOND_LEGGINGS, Material.GOLDEN_LEGGINGS, Material.IRON_LEGGINGS, Material.NETHERITE_LEGGINGS, Material.CHAINMAIL_LEGGINGS, Material.LEATHER_LEGGINGS -> true;
                default -> false;
            };
        }
        return false;
    }

    default public boolean isChestplate(ItemStack it) {
        if (this.isItem(it)) {
            return switch (it.getType()) {
                case Material.DIAMOND_CHESTPLATE, Material.GOLDEN_CHESTPLATE, Material.IRON_CHESTPLATE, Material.NETHERITE_CHESTPLATE, Material.CHAINMAIL_CHESTPLATE, Material.LEATHER_CHESTPLATE -> true;
                default -> false;
            };
        }
        return false;
    }

    default public boolean isElytra(ItemStack it) {
        if (this.isItem(it)) {
            return switch (it.getType()) {
                case Material.ELYTRA, Material.LEGACY_ELYTRA -> true;
                default -> false;
            };
        }
        return false;
    }

    default public boolean isHoe(ItemStack it) {
        if (this.isItem(it)) {
            return switch (it.getType()) {
                case Material.DIAMOND_HOE, Material.GOLDEN_HOE, Material.IRON_HOE, Material.NETHERITE_HOE, Material.STONE_HOE, Material.WOODEN_HOE -> true;
                default -> false;
            };
        }
        return false;
    }

    default public boolean isOre(BlockData b) {
        return switch (b.getMaterial()) {
            case Material.COPPER_ORE, Material.DEEPSLATE_COPPER_ORE, Material.COAL_ORE, Material.GOLD_ORE, Material.IRON_ORE, Material.DIAMOND_ORE, Material.LAPIS_ORE, Material.EMERALD_ORE, Material.NETHER_QUARTZ_ORE, Material.NETHER_GOLD_ORE, Material.REDSTONE_ORE, Material.DEEPSLATE_COAL_ORE, Material.DEEPSLATE_IRON_ORE, Material.DEEPSLATE_GOLD_ORE, Material.DEEPSLATE_LAPIS_ORE, Material.DEEPSLATE_DIAMOND_ORE, Material.DEEPSLATE_EMERALD_ORE, Material.DEEPSLATE_REDSTONE_ORE -> true;
            default -> false;
        };
    }

    default public boolean isStorage(BlockData b) {
        return switch (b.getMaterial()) {
            case Material.CHEST, Material.SMOKER, Material.TRAPPED_CHEST, Material.SHULKER_BOX, Material.WHITE_SHULKER_BOX, Material.ORANGE_SHULKER_BOX, Material.MAGENTA_SHULKER_BOX, Material.LIGHT_BLUE_SHULKER_BOX, Material.YELLOW_SHULKER_BOX, Material.LIME_SHULKER_BOX, Material.PINK_SHULKER_BOX, Material.GRAY_SHULKER_BOX, Material.LIGHT_GRAY_SHULKER_BOX, Material.CYAN_SHULKER_BOX, Material.PURPLE_SHULKER_BOX, Material.BLUE_SHULKER_BOX, Material.BROWN_SHULKER_BOX, Material.GREEN_SHULKER_BOX, Material.RED_SHULKER_BOX, Material.BLACK_SHULKER_BOX, Material.BARREL, Material.DISPENSER, Material.DROPPER, Material.FURNACE, Material.BLAST_FURNACE, Material.HOPPER -> true;
            default -> false;
        };
    }
}

