/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.crafting;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;

public class CraftingXP
extends SimpleAdaptation<Config> {
    private final Map<Player, Long> cooldown = new HashMap<Player, Long>();

    public CraftingXP() {
        super("crafting-xp");
        this.registerConfiguration(Config.class);
        this.setDisplayName(Localizer.dLocalize("crafting", "xp", "name"));
        this.setDescription(Localizer.dLocalize("crafting", "xp", "description"));
        this.setIcon(Material.EXPERIENCE_BOTTLE);
        this.setInterval(5580L);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + Localizer.dLocalize("crafting", "xp", "lore1"));
    }

    @EventHandler
    public void on(PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        this.cooldown.remove(player);
    }

    @EventHandler(priority=EventPriority.LOW)
    public void on(CraftItemEvent craftItemEvent) {
        if (craftItemEvent.isCancelled()) {
            return;
        }
        Player player = (Player)craftItemEvent.getWhoClicked();
        if (craftItemEvent.getInventory().getResult() != null && !craftItemEvent.isCancelled() && this.hasAdaptation(player) && craftItemEvent.getInventory().getResult().getAmount() > 0 && craftItemEvent.getInventory().getResult() != null && craftItemEvent.getCursor() != null && craftItemEvent.getCursor().getAmount() < 64 && player.getInventory().addItem(new ItemStack[]{craftItemEvent.getCurrentItem()}).isEmpty()) {
            player.getInventory().removeItem(new ItemStack[]{craftItemEvent.getCurrentItem()});
            if (this.cooldown.containsKey(player) && this.cooldown.get(player) + 20000L < System.currentTimeMillis()) {
                this.cooldown.remove(player);
            } else if (this.cooldown.containsKey(player) && this.cooldown.get(player) + 20000L > System.currentTimeMillis()) {
                return;
            }
            this.cooldown.put(player, System.currentTimeMillis());
            ((ExperienceOrb)player.getWorld().spawn(player.getLocation(), ExperienceOrb.class)).setExperience(this.getLevel(player) * 2);
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 2;
        int initialCost = 3;
        double costFactor = 0.3;
        int maxLevel = 7;

        static {
            IBootstrap.dasBoot();
        }
    }
}

