/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.discovery;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import de.slikey.effectlib.effect.BleedEffect;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class DiscoveryVillagerAtt
extends SimpleAdaptation<Config> {
    public DiscoveryVillagerAtt() {
        super("discovery-villager-att");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("discovery", "villager", "description"));
        this.setDisplayName(Localizer.dLocalize("discovery", "villager", "name"));
        this.setIcon(Material.GLASS_BOTTLE);
        this.setInterval(5832L);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + "+ " + C.GRAY + Localizer.dLocalize("discovery", "villager", "lore1"));
        element.addLore(C.GREEN + "+ " + Form.pc(this.getEffectiveness(this.getLevelPercent(n)), 0) + C.GRAY + " " + Localizer.dLocalize("discovery", "villager", "lore2"));
        element.addLore(C.GREEN + "+ " + this.getXpTaken(n) + " " + C.GRAY + Localizer.dLocalize("discovery", "villager", "lore3"));
    }

    private double getEffectiveness(double d) {
        return Math.min(((Config)this.getConfig()).maxEffectiveness, d * d + ((Config)this.getConfig()).effectivenessBase);
    }

    private int getXpTaken(double d) {
        double d2 = (double)((Config)this.getConfig()).levelCostAdd * ((Config)this.getConfig()).amplifier - d * (double)((Config)this.getConfig()).levelDrain;
        return (int)d2;
    }

    @EventHandler
    public void on(PlayerInteractEntityEvent playerInteractEntityEvent) {
        if (playerInteractEntityEvent.isCancelled()) {
            return;
        }
        Player player = playerInteractEntityEvent.getPlayer();
        Object object = playerInteractEntityEvent.getRightClicked();
        if (object instanceof Villager) {
            Villager villager = (Villager)object;
            if (this.hasAdaptation(player) && ((Random)(object = new Random())).nextDouble() <= this.getEffectiveness(this.getLevelPercent(this.getLevel(player)))) {
                if (player.getLevel() - this.getXpTaken(this.getLevel(player)) > 0) {
                    BleedEffect bleedEffect = new BleedEffect(Adapt.instance.adaptEffectManager);
                    bleedEffect.material = Material.EMERALD;
                    bleedEffect.setEntity((Entity)villager);
                    player.setLevel(player.getLevel() - this.getXpTaken(this.getLevel(player)));
                    player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_CELEBRATE, 1.0f, 1.0f);
                    player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                    player.addPotionEffect(new PotionEffect(PotionEffectType.HERO_OF_THE_VILLAGE, 10, this.getLevel(player), true, true));
                } else {
                    BleedEffect bleedEffect = new BleedEffect(Adapt.instance.adaptEffectManager);
                    bleedEffect.material = Material.STONE;
                    villager.shakeHead();
                    bleedEffect.setEntity((Entity)villager);
                    player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                }
            }
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 1;
        int initialCost = 5;
        double costFactor = 0.01;
        int maxLevel = 5;
        double effectivenessBase = 0.005;
        double maxEffectiveness = 100.0;
        int levelDrain = 2;
        int levelCostAdd = 10;
        double amplifier = 1.0;

        static {
            IBootstrap.dasBoot();
        }
    }
}

