/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.herbalism;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.content.item.ItemListings;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.extensions.java.util.List.XList;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.inventory.ItemStack;

public class HerbalismLuck
extends SimpleAdaptation<Config> {
    public HerbalismLuck() {
        super("herbalism-luck");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("herbalism", "luck", "description"));
        this.setDisplayName(Localizer.dLocalize("herbalism", "luck", "name"));
        this.setIcon(Material.EMERALD);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInterval(8121L);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + "+ " + C.GRAY + Localizer.dLocalize("herbalism", "luck", "lore0"));
        element.addLore(C.GREEN + "+ (" + this.getEffectiveness(n) + C.GRAY + "%) + " + Localizer.dLocalize("herbalism", "luck", "lore1"));
        element.addLore(C.GREEN + "+ (" + this.getEffectiveness(n) + C.GRAY + "%) + " + Localizer.dLocalize("herbalism", "luck", "lore2"));
    }

    private double getEffectiveness(double d) {
        return Math.min(((Config)this.getConfig()).highChance, d * d + ((Config)this.getConfig()).lowChance);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void on(BlockDropItemEvent blockDropItemEvent) {
        ItemStack itemStack;
        Material material;
        double d;
        if (blockDropItemEvent.isCancelled()) {
            return;
        }
        Player player = blockDropItemEvent.getPlayer();
        if (!this.hasAdaptation(player)) {
            return;
        }
        Block block = blockDropItemEvent.getBlock();
        if (block.getType() == Material.GRASS || block.getType() == Material.TALL_GRASS) {
            d = Math.random() * 100.0;
            material = XList.getRandom(ItemListings.getHerbalLuckSeeds());
            if (d < this.getEffectiveness(this.getLevel(player))) {
                this.xp(player, 100.0);
                itemStack = new ItemStack(material, 1);
                blockDropItemEvent.getBlock().getWorld().dropItem(blockDropItemEvent.getBlock().getLocation(), itemStack);
            }
        }
        if (ItemListings.getFlowers().contains(block.getType())) {
            d = Math.random() * 100.0;
            material = XList.getRandom(ItemListings.getHerbalLuckFood());
            if (d < this.getEffectiveness(this.getLevel(player))) {
                this.xp(player, 100.0);
                itemStack = new ItemStack(material, 1);
                blockDropItemEvent.getBlock().getWorld().dropItem(blockDropItemEvent.getBlock().getLocation(), itemStack);
            }
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 8;
        int maxLevel = 7;
        int initialCost = 3;
        double costFactor = 0.75;
        double lowChance = 0.0;
        double highChance = 90.0;

        static {
            IBootstrap.dasBoot();
        }
    }
}

