/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.rift;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.api.adaptation.chunk.ChunkLoading;
import com.volmit.adapt.content.adaptation.rift.RiftResist;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.util.Vector;

public class RiftBlink
extends SimpleAdaptation<Config> {
    private final Map<Player, Long> lastJump = new HashMap<Player, Long>();
    private final Map<Player, Boolean> canBlink = new HashMap<Player, Boolean>();
    private final double jumpVelocity = -0.0784000015258789;

    public RiftBlink() {
        super("rift-blink");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("rift", "blink", "description"));
        this.setDisplayName(Localizer.dLocalize("rift", "blink", "name"));
        this.setIcon(Material.FEATHER);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setInterval(9288L);
    }

    private double getBlinkDistance(int n) {
        return ((Config)this.getConfig()).baseDistance + this.getLevelPercent(n) * ((Config)this.getConfig()).distanceFactor;
    }

    private int getCooldownDuration() {
        return 2000;
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + "+ " + this.getBlinkDistance(n) + C.GRAY + " " + Localizer.dLocalize("rift", "blink", "lore1"));
        element.addLore(C.ITALIC + Localizer.dLocalize("rift", "blink", "lore2") + C.DARK_PURPLE + Localizer.dLocalize("rift", "blink", "lore3"));
    }

    @EventHandler
    public void on(PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        this.lastJump.remove(player);
        this.canBlink.remove(player);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(PlayerToggleFlightEvent playerToggleFlightEvent) {
        Player player = playerToggleFlightEvent.getPlayer();
        if (this.hasAdaptation(player) && player.getGameMode().equals((Object)GameMode.SURVIVAL)) {
            playerToggleFlightEvent.setCancelled(true);
            player.setAllowFlight(false);
            if (this.lastJump.get(player) != null && M.ms() - this.lastJump.get(player) <= (long)this.getCooldownDuration()) {
                return;
            }
            if (player.isSprinting()) {
                Location location2 = player.getLocation().clone();
                Location location3 = player.getLocation().clone();
                Vector vector = location2.getDirection();
                double d = this.getBlinkDistance(this.getLevel(player));
                vector.multiply(d);
                location2.add(vector);
                double d2 = d * 2.0;
                location2.subtract(0.0, d, 0.0);
                while (!this.isSafe(location2)) {
                    double d3 = d2;
                    d2 = d3 - 1.0;
                    if (!(d3 > 0.0)) break;
                    location2.add(0.0, 1.0, 0.0);
                }
                if (!this.isSafe(location2)) {
                    player.getWorld().playSound(player.getLocation(), Sound.BLOCK_CONDUIT_DEACTIVATE, 1.0f, 1.24f);
                    this.lastJump.put(player, M.ms());
                    return;
                }
                if (this.getPlayer(player).getData().getSkillLines().get("rift").getAdaptations().get("rift-resist") != null && this.getPlayer(player).getData().getSkillLines().get("rift").getAdaptations().get("rift-resist").getLevel() > 0) {
                    RiftResist.riftResistStackAdd(player, 10, 5);
                }
                if (((Config)this.getConfig()).showParticles) {
                    this.vfxParticleLine(location3, location2, Particle.REVERSE_PORTAL, 50, 8, 0.1, 1.0, 0.1, 0.0, null, false, location -> location.getBlock().isPassable());
                }
                Vector vector2 = player.getVelocity().clone();
                ChunkLoading.loadChunkAsync(location2, chunk -> {
                    J.s(() -> player.teleport(location2.add(0.0, 1.0, 0.0), PlayerTeleportEvent.TeleportCause.PLUGIN));
                    J.s(() -> player.setVelocity(vector2.multiply(3)), 2);
                });
                this.lastJump.put(player, M.ms());
                player.getWorld().playSound(player.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 0.5f, 1.0f);
                this.vfxLevelUp(player);
            }
        }
    }

    @EventHandler
    public void on(PlayerMoveEvent playerMoveEvent) {
        boolean bl;
        Player player = playerMoveEvent.getPlayer();
        boolean bl2 = bl = player.getVelocity().getY() > -0.0784000015258789;
        if (bl && !this.canBlink.containsKey(player) && this.hasAdaptation(player) && player.getGameMode().equals((Object)GameMode.SURVIVAL) && player.isSprinting()) {
            if (this.lastJump.get(player) != null && M.ms() - this.lastJump.get(player) <= (long)this.getCooldownDuration()) {
                player.setAllowFlight(false);
                return;
            }
            Location location = player.getLocation().clone();
            Vector vector = location.getDirection();
            double d = this.getBlinkDistance(this.getLevel(player));
            vector.multiply(d);
            location.add(vector);
            double d2 = d * 2.0;
            location.subtract(0.0, d, 0.0);
            while (!this.isSafe(location)) {
                double d3 = d2;
                d2 = d3 - 1.0;
                if (!(d3 > 0.0)) break;
                location.add(0.0, 1.0, 0.0);
            }
            if (this.isSafe(location)) {
                this.canBlink.put(player, true);
                player.setAllowFlight(true);
                Adapt.verbose("Allowing flight for " + player.getName());
                J.a(() -> {
                    player.setAllowFlight(false);
                    player.setFlying(false);
                    Adapt.verbose("Disabling flight for " + player.getName());
                    this.canBlink.remove(player);
                }, 25);
            }
        } else {
            this.canBlink.remove(player);
        }
    }

    private boolean isSafe(Location location) {
        return location.getBlock().getType().isSolid() && !location.getBlock().getRelative(BlockFace.UP).getType().isSolid() && !location.getBlock().getRelative(BlockFace.UP).getRelative(BlockFace.UP).getType().isSolid();
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        boolean showParticles = true;
        int baseCost = 7;
        double costFactor = 0.12;
        int maxLevel = 5;
        int initialCost = 1;
        double baseDistance = 6.0;
        double distanceFactor = 5.0;

        static {
            IBootstrap.dasBoot();
        }
    }
}

