/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.unarmed;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class UnarmedPower
extends SimpleAdaptation<Config> {
    public UnarmedPower() {
        super("unarmed-power");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("unarmed", "power", "description"));
        this.setDisplayName(Localizer.dLocalize("unarmed", "power", "name"));
        this.setIcon(Material.LEATHER_HELMET);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setInterval(4444L);
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + "+ " + Form.pc(this.getUnarmedDamage(n), 0) + C.GRAY + Localizer.dLocalize("unarmed", "power", "lore1"));
    }

    @EventHandler
    public void on(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (entityDamageByEntityEvent.isCancelled()) {
            return;
        }
        Entity entity = entityDamageByEntityEvent.getDamager();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!this.hasAdaptation(player)) {
                return;
            }
            if (player.getInventory().getItemInMainHand().getType() != Material.AIR && player.getInventory().getItemInOffHand().getType() != Material.AIR) {
                return;
            }
            double d = this.getLevelPercent(player);
            if (d <= 0.0) {
                return;
            }
            entityDamageByEntityEvent.setDamage(entityDamageByEntityEvent.getDamage() * (1.0 + this.getUnarmedDamage(this.getLevel(player))));
            this.getSkill().xp(player, 0.321 * d * entityDamageByEntityEvent.getDamage());
        }
    }

    private double getUnarmedDamage(int n) {
        return this.getLevelPercent(n) * ((Config)this.getConfig()).damageFactor;
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 3;
        int maxLevel = 7;
        int initialCost = 6;
        double costFactor = 0.425;
        double damageFactor = 2.57;

        static {
            IBootstrap.dasBoot();
        }
    }
}

