/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.unarmed;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class UnarmedSuckerPunch
extends SimpleAdaptation<Config> {
    public UnarmedSuckerPunch() {
        super("unarmed-sucker-punch");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("unarmed", "suckerpunch", "description"));
        this.setDisplayName(Localizer.dLocalize("unarmed", "suckerpunch", "name"));
        this.setIcon(Material.OBSIDIAN);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setInterval(4944L);
    }

    @Override
    public void addStats(int n, Element element) {
        double d = this.getLevelPercent(n);
        double d2 = this.getDamage(d);
        element.addLore(C.GREEN + "+ " + Form.pc(d2, 0) + C.GRAY + " " + Localizer.dLocalize("unarmed", "suckerpunch", "lore1"));
        element.addLore(C.GRAY + Localizer.dLocalize("unarmed", "suckerpunch", "lore2"));
    }

    private double getDamage(double d) {
        return ((Config)this.getConfig()).baseDamage + d * ((Config)this.getConfig()).damageFactor;
    }

    @EventHandler
    public void on(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (entityDamageByEntityEvent.isCancelled()) {
            return;
        }
        Entity entity = entityDamageByEntityEvent.getDamager();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!this.hasAdaptation(player)) {
                return;
            }
            if (player.getInventory().getItemInMainHand().getType() != Material.AIR && player.getInventory().getItemInOffHand().getType() != Material.AIR) {
                return;
            }
            double d = this.getLevelPercent(player);
            if (!player.isSprinting()) {
                return;
            }
            if (d <= 0.0) {
                return;
            }
            if (this.isTool(player.getInventory().getItemInMainHand())) {
                return;
            }
            entityDamageByEntityEvent.setDamage(entityDamageByEntityEvent.getDamage() * this.getDamage(d));
            entityDamageByEntityEvent.getEntity().getWorld().playSound(entityDamageByEntityEvent.getEntity().getLocation(), Sound.ENTITY_PLAYER_ATTACK_STRONG, 1.0f, 1.8f);
            entityDamageByEntityEvent.getEntity().getWorld().playSound(entityDamageByEntityEvent.getEntity().getLocation(), Sound.BLOCK_BASALT_BREAK, 1.0f, 0.6f);
            this.getSkill().xp(player, 6.221 * entityDamageByEntityEvent.getDamage());
            if (entityDamageByEntityEvent.getDamage() > 5.0) {
                this.getSkill().xp(player, 0.42 * entityDamageByEntityEvent.getDamage());
                if (((Config)this.getConfig()).showParticles) {
                    entityDamageByEntityEvent.getEntity().getWorld().spawnParticle(Particle.FLASH, entityDamageByEntityEvent.getEntity().getLocation(), 1);
                }
            }
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        boolean showParticles = true;
        int baseCost = 2;
        int initialCost = 4;
        double costFactor = 0.225;
        double baseDamage = 0.2;
        double damageFactor = 0.55;

        static {
            IBootstrap.dasBoot();
        }
    }
}

