/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.item;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.item.DataItem;
import com.volmit.adapt.api.skill.Skill;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ExperienceOrb
implements DataItem<Data> {
    public static ExperienceOrb io;

    public static Data get(ItemStack itemStack) {
        return (Data)io.getData(itemStack);
    }

    public static void set(ItemStack itemStack, String string, double d) {
        io.setData(itemStack, new Data(string, d));
    }

    public static ItemStack with(String string, double d) {
        return io.withData(new Data(string, d));
    }

    @Override
    public Material getMaterial() {
        return Material.SNOWBALL;
    }

    @Override
    public Class<Data> getType() {
        return Data.class;
    }

    @Override
    public void applyLore(Data data, List<String> list) {
        Skill<?> skill = Adapt.instance.getAdaptServer().getSkillRegistry().getSkill(data.skill);
        list.add(C.WHITE + Localizer.dLocalize("snippets", "experienceorb", "contains") + " " + C.UNDERLINE + C.WHITE + Form.f(data.experience, 0) + " " + skill.getDisplayName() + C.GRAY + " " + Localizer.dLocalize("snippets", "experienceorb", "xp"));
        list.add(C.LIGHT_PURPLE + Localizer.dLocalize("snippets", "experienceorb", "rightclick") + " " + C.GRAY + Localizer.dLocalize("snippets", "experienceorb", "togainxp"));
    }

    @Override
    public void applyMeta(Data data, ItemMeta itemMeta) {
        itemMeta.addEnchant(Enchantment.BINDING_CURSE, 10, true);
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS});
        itemMeta.setDisplayName(Adapt.instance.getAdaptServer().getSkillRegistry().getSkill(data.skill).getDisplayName() + " " + Localizer.dLocalize("snippets", "experienceorb", "xporb"));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ExperienceOrb)) {
            return false;
        }
        ExperienceOrb experienceOrb = (ExperienceOrb)object;
        return experienceOrb.canEqual(this);
    }

    protected boolean canEqual(Object object) {
        return object instanceof ExperienceOrb;
    }

    public int hashCode() {
        boolean bl = true;
        return 1;
    }

    public String toString() {
        return "ExperienceOrb()";
    }

    static {
        IBootstrap.dasBoot();
        io = new ExperienceOrb();
    }

    public static class Data {
        private String skill;
        private double experience;

        public void apply(Player player) {
            Adapt.instance.getAdaptServer().getPlayer(player).getSkillLine(this.skill).giveXPFresh(Adapt.instance.getAdaptServer().getPlayer(player).getNot(), this.experience);
        }

        public Data(String string, double d) {
            this.skill = string;
            this.experience = d;
        }

        public String getSkill() {
            return this.skill;
        }

        public double getExperience() {
            return this.experience;
        }

        public void setSkill(String string) {
            this.skill = string;
        }

        public void setExperience(double d) {
            this.experience = d;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Data)) {
                return false;
            }
            Data data = (Data)object;
            if (!data.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getExperience(), data.getExperience()) != 0) {
                return false;
            }
            String string = this.getSkill();
            String string2 = data.getSkill();
            return !(string == null ? string2 != null : !string.equals(string2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof Data;
        }

        public int hashCode() {
            int n = 59;
            int n2 = 1;
            long l = Double.doubleToLongBits(this.getExperience());
            n2 = n2 * 59 + (int)(l >>> 32 ^ l);
            String string = this.getSkill();
            n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
            return n2;
        }

        public String toString() {
            return "ExperienceOrb.Data(skill=" + this.getSkill() + ", experience=" + this.getExperience() + ")";
        }

        static {
            IBootstrap.dasBoot();
        }
    }
}

