/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.skill;

import com.volmit.adapt.api.skill.SimpleSkill;
import com.volmit.adapt.content.adaptation.ranged.RangedArrowRecovery;
import com.volmit.adapt.content.adaptation.ranged.RangedForce;
import com.volmit.adapt.content.adaptation.ranged.RangedLungeShot;
import com.volmit.adapt.content.adaptation.ranged.RangedPiercing;
import com.volmit.adapt.content.adaptation.ranged.RangedWebBomb;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Snowball;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.projectiles.ProjectileSource;

public class SkillRanged
extends SimpleSkill<Config> {
    private final Map<Player, Long> cooldowns;

    public SkillRanged() {
        super("ranged", Localizer.dLocalize("skill", "ranged", "icon"));
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("skill", "ranged", "description"));
        this.setDisplayName(Localizer.dLocalize("skill", "ranged", "name"));
        this.setColor(C.DARK_GREEN);
        this.setInterval(3044L);
        this.registerAdaptation(new RangedForce());
        this.registerAdaptation(new RangedPiercing());
        this.registerAdaptation(new RangedArrowRecovery());
        this.registerAdaptation(new RangedLungeShot());
        this.registerAdaptation(new RangedWebBomb());
        this.setIcon(Material.CROSSBOW);
        this.cooldowns = new HashMap<Player, Long>();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(ProjectileLaunchEvent projectileLaunchEvent) {
        ProjectileSource projectileSource = projectileLaunchEvent.getEntity().getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Player player = (Player)projectileSource;
        this.shouldReturnForPlayer(player, (Cancellable)projectileLaunchEvent, () -> {
            if (projectileLaunchEvent.getEntity() instanceof Snowball || projectileLaunchEvent.getEntity() instanceof EntityFishingHook) {
                return;
            }
            this.getPlayer(player).getData().addStat("ranged.shotsfired", 1.0);
            this.getPlayer(player).getData().addStat("ranged.shotsfired." + projectileLaunchEvent.getEntity().getType().name().toLowerCase(Locale.ROOT), 1.0);
            if (this.cooldowns.containsKey(player)) {
                if (this.cooldowns.get(player) + ((Config)this.getConfig()).cooldownDelay > System.currentTimeMillis()) {
                    return;
                }
                this.cooldowns.remove(player);
            }
            this.cooldowns.put(player, System.currentTimeMillis());
            this.xp(player, ((Config)this.getConfig()).shootXP);
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        Player player;
        block3: {
            block2: {
                ProjectileSource projectileSource;
                if (!(entityDamageByEntityEvent.getDamager() instanceof Projectile) || !((projectileSource = ((Projectile)entityDamageByEntityEvent.getDamager()).getShooter()) instanceof Player)) break block2;
                player = (Player)projectileSource;
                if (this.checkValidEntity(entityDamageByEntityEvent.getEntity().getType())) break block3;
            }
            return;
        }
        this.shouldReturnForPlayer(player, (Cancellable)entityDamageByEntityEvent, () -> {
            if (entityDamageByEntityEvent.getEntity() instanceof Snowball || entityDamageByEntityEvent.getEntity() instanceof EntityFishingHook) {
                return;
            }
            this.getPlayer(player).getData().addStat("ranged.damage", entityDamageByEntityEvent.getDamage());
            this.getPlayer(player).getData().addStat("ranged.distance", entityDamageByEntityEvent.getEntity().getLocation().distance(player.getLocation()));
            this.getPlayer(player).getData().addStat("ranged.damage." + entityDamageByEntityEvent.getDamager().getType().name().toLowerCase(Locale.ROOT), entityDamageByEntityEvent.getDamage());
            this.getPlayer(player).getData().addStat("ranged.distance." + entityDamageByEntityEvent.getDamager().getType().name().toLowerCase(Locale.ROOT), entityDamageByEntityEvent.getEntity().getLocation().distance(player.getLocation()));
            if (this.cooldowns.containsKey(player)) {
                if (this.cooldowns.get(player) + ((Config)this.getConfig()).cooldownDelay > System.currentTimeMillis()) {
                    return;
                }
                this.cooldowns.remove(player);
            }
            this.cooldowns.put(player, System.currentTimeMillis());
            this.xp(player, entityDamageByEntityEvent.getEntity().getLocation(), ((Config)this.getConfig()).hitDamageXPMultiplier * entityDamageByEntityEvent.getDamage() + entityDamageByEntityEvent.getEntity().getLocation().distance(player.getLocation()) * ((Config)this.getConfig()).hitDistanceXPMultiplier);
        });
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean enabled = true;
        double shootXP = 5.0;
        long cooldownDelay = 1250L;
        double hitDamageXPMultiplier = 2.125;
        double hitDistanceXPMultiplier = 1.7;

        static {
            IBootstrap.dasBoot();
        }
    }
}

